/*
 * Copyright 2009 Markus KARG
 *
 * This file is part of webdav-addressbook.
 *
 * webdav-addressbook is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * webdav-addressbook is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with webdav-addressbook.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.java.dev.webdav.addressbook;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/**
 * This implementation of {@link Filter} provides timing of request processing.
 * 
 * @author Markus KARG (mkarg@users.dev.java.net) *
 */
public final class TimingFilter implements Filter {

	@Override
	public void init(final FilterConfig config) throws ServletException {
		// Intentionally left blank.
	}

	@Override
	public final void destroy() {
		// Intentionally left blank.
	}

	@Override
	public final void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain chain) throws IOException, ServletException {
		final long startTime = System.nanoTime();
		chain.doFilter(request, response);
		System.out.println(String.format("Processing Time: %fms", (System.nanoTime() - startTime) / 1000000.0));
	}

}