/*
 * Copyright 2009 Markus KARG
 *
 * This file is part of webdav-addressbook.
 *
 * webdav-addressbook is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * webdav-addressbook is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with webdav-addressbook.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.java.dev.webdav.addressbook;

import java.io.IOException;
import java.io.OutputStream;

/**
 * An <code>OutputStream</code> that discards the actual data but just counts
 * the number of bytes written.
 * 
 * @see #getSize()
 * 
 * @author Markus KARG (mkarg@users.dev.java.net)
 */
public final class NullOutputStream extends OutputStream {

	private int size;

	@Override
	public final void write(final byte[] b, final int off, final int len) throws IOException {
		this.size += len;
	}

	@Override
	public final void write(final byte[] b) throws IOException {
		this.size += b.length;
	}

	@Override
	public final void write(final int b) throws IOException {
		this.size++;
	}

	/**
	 * @return The number of bytes written into this stream.
	 */
	public final int getSize() {
		return this.size;
	}

}
