/*
 * Copyright 2008, 2009 Markus KARG
 *
 * This file is part of webdav-jaxrs.
 *
 * webdav-jaxrs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * webdav-jaxrs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with webdav-jaxrs.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.java.dev.webdav.addressbook;

import static com.sun.grizzly.http.servlet.ServletAdapter.LOAD_ON_STARTUP;

import java.util.Collections;

import net.java.dev.webdav.interop.WindowsRedirectorPatchResourceFilter;

import com.sun.grizzly.http.embed.GrizzlyWebServer;
import com.sun.grizzly.http.servlet.ServletAdapter;
import com.sun.jersey.spi.container.servlet.ServletContainer;

/**
 * Main class of JPA Address Book Sample.<br>
 * 
 * @author Markus KARG (mkarg@dev.users.java.net)
 */
public final class Main {

	public static final void main(final String[] args) throws Exception {
		System.out.println("Sample Server running on port 80... Kill process to stop.");
		final GrizzlyWebServer ws = new GrizzlyWebServer(80);
		final ServletAdapter sa = new ServletAdapter(new ServletContainer(AddressBookApplication.class));
		sa.setProperty(LOAD_ON_STARTUP, "1");
		sa.addFilter(new TimingFilter(), "Timing", Collections.EMPTY_MAP);
		sa.addFilter(new LoggingFilter(), "Logging", Collections.EMPTY_MAP);
		sa.addFilter(new WindowsRedirectorPatchResourceFilter(), "Microsoft Interop", Collections.EMPTY_MAP);
		ws.addGrizzlyAdapter(sa, null);
		ws.start();
	}

}
