/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.ant;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.java.dev.vcc.ant.AbstractDatacenterTask;
import net.java.dev.vcc.ant.ComputerElement;
import net.java.dev.vcc.api.Computer;
import net.java.dev.vcc.api.Datacenter;
import net.java.dev.vcc.api.Success;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComputerActionTask
extends AbstractDatacenterTask {
    private List<ComputerElement> computers = new ArrayList<ComputerElement>();
    private int timeout = 60;

    @Override
    protected final void execute(Datacenter datacenter) throws BuildException {
        HashSet<String> targets = new HashSet<String>();
        if (this.computers != null) {
            for (ComputerElement c : this.computers) {
                targets.add(c.getName());
            }
        }
        LinkedHashMap<String, Future<Success>> results = new LinkedHashMap<String, Future<Success>>();
        for (Computer c : datacenter.getAllComputers()) {
            if (!targets.contains(c.getId().toString())) continue;
            this.log("Computer " + c.getName() + " is in state " + c.getState(), 4);
            results.put(c.getName(), this.doAction(c));
            targets.remove(c.getName());
        }
        if (!targets.isEmpty()) {
            throw new BuildException("Could not find the following computers: " + targets);
        }
        long giveUp = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.timeout);
        while (System.currentTimeMillis() < giveUp && !results.isEmpty()) {
            Iterator it = results.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                try {
                    ((Future)entry.getValue()).get(giveUp - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                    this.recordSuccess((String)entry.getKey());
                    it.remove();
                }
                catch (ExecutionException e) {
                    this.recordFailure((String)entry.getKey());
                    it.remove();
                    throw new BuildException(e.getMessage(), (Throwable)e);
                }
                catch (TimeoutException e) {
                    throw new BuildException(e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new BuildException(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    protected abstract void recordFailure(String var1);

    protected abstract void recordSuccess(String var1);

    protected abstract Future<Success> doAction(Computer var1);

    public final int getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public final void addConfiguredComputer(ComputerElement aComputer) {
        this.computers.add(aComputer);
    }
}

