/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.util;

import java.util.concurrent.TimeUnit;
import net.java.dev.vcc.util.TaskController;

public abstract class PollingTask
implements Runnable {
    private final Runnable pollTask;
    private final Object averageLock = new Object();
    private double fastAverage = 1.0;
    private double slowAverage = 1.0;
    private static final double FAST_RATE = 0.1;
    private static final double SLOW_RATE = 0.001;
    protected static final double TO_SECONDS = 1.0 / (double)TimeUnit.SECONDS.toNanos(1L);
    private final TaskController controller;

    protected PollingTask(TaskController controller, Runnable work) {
        this.controller = controller;
        this.pollTask = work;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double poll() {
        if (this.controller.isActive()) {
            long pollStart = System.nanoTime();
            try {
                this.pollTask.run();
            }
            catch (Throwable t) {
                // empty catch block
            }
            long pollEnd = System.nanoTime();
            double pollDuration = (double)(pollEnd - pollStart) * TO_SECONDS;
            if (!(pollDuration < 0.0)) {
                Object object = this.averageLock;
                synchronized (object) {
                    this.fastAverage = this.fastAverage * 0.9 + pollDuration * 0.1;
                    this.slowAverage = this.slowAverage * 0.999 + pollDuration * 0.001;
                }
            }
            return pollDuration;
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getFastAverage() {
        Object object = this.averageLock;
        synchronized (object) {
            return this.fastAverage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSlowAverage() {
        Object object = this.averageLock;
        synchronized (object) {
            return this.slowAverage;
        }
    }

    public TaskController getController() {
        return this.controller;
    }
}

