/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.java.dev.vcc.util.TaskController;

public class AtomicTaskController
implements TaskController {
    private final Lock activeLock = new ReentrantLock();
    private final Condition deactivated = this.activeLock.newCondition();
    private boolean active = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        this.activeLock.lock();
        try {
            boolean bl = this.active;
            return bl;
        }
        finally {
            this.activeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitDeactivated() throws InterruptedException {
        this.activeLock.lock();
        try {
            while (this.active) {
                this.deactivated.await();
            }
        }
        finally {
            this.activeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitDeactivated(long timeout, TimeUnit unit) throws InterruptedException {
        this.activeLock.lock();
        try {
            long nanosTimeout = unit.toNanos(timeout);
            while (this.active) {
                if (nanosTimeout > 0L) {
                    nanosTimeout = this.deactivated.awaitNanos(nanosTimeout);
                    continue;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.activeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.activeLock.lock();
        try {
            this.active = false;
            this.deactivated.signalAll();
        }
        finally {
            this.activeLock.unlock();
        }
    }
}

