/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.dev.vcc.util.JDK5ServiceLoaderImpl;
import net.java.dev.vcc.util.ServiceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLoaderProxy<S>
implements ServiceLoader<S> {
    private final ServiceLoader<S> delegate;

    private ServiceLoaderProxy(ServiceLoader<S> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void reload() {
        this.delegate.reload();
    }

    @Override
    public Iterator<S> iterator() {
        return this.delegate.iterator();
    }

    public static <S> ServiceLoaderProxy<S> load(Class<S> service, ClassLoader loader) {
        Logger logger = Logger.getLogger(ServiceLoaderProxy.class.getName());
        try {
            Constructor constructor = AdapterProvider.provider.getConstructor(Class.class, ClassLoader.class);
            return new ServiceLoaderProxy<S>((ServiceLoader)constructor.newInstance(service, loader));
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        catch (InstantiationException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return new ServiceLoaderProxy<S>(new JDK5ServiceLoaderImpl<S>(service, loader));
    }

    public static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader cl = null;
                cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = ClassLoader.getSystemClassLoader();
                }
                return cl;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AdapterProvider {
        private static final Class<? extends ServiceLoader> provider = AdapterProvider.findProvider();

        private AdapterProvider() {
        }

        private static Class<? extends ServiceLoader> findProvider() {
            try {
                Class.forName("java.util.ServiceLoader", false, ClassLoader.getSystemClassLoader());
                return ServiceLoaderProxy.class.getClassLoader().loadClass(ServiceLoaderProxy.class.getPackage().getName() + ".JDK6ServiceLoaderImpl");
            }
            catch (ClassNotFoundException e) {
                return JDK5ServiceLoaderImpl.class;
            }
            catch (SecurityException e) {
                return JDK5ServiceLoaderImpl.class;
            }
        }
    }
}

