/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.spi;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import net.java.dev.vcc.api.Log;
import net.java.dev.vcc.api.LogFactory;

public abstract class AbstractLogFactory
implements LogFactory {
    private final Map<String, WeakReference<Log>> logs = new WeakHashMap<String, WeakReference<Log>>();

    public final Log getLog(Class clazz) {
        return this.getLog(clazz.getName(), null);
    }

    public final Log getLog(String name) {
        return this.getLog(name, null);
    }

    public final Log getLog(Class clazz, String bundleName) {
        return this.getLog(clazz.getName(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Log getLog(String name, String bundleName) {
        String key = (name == null ? "null" : name) + ":" + (bundleName == null ? "null" : bundleName);
        Map<String, WeakReference<Log>> map = this.logs;
        synchronized (map) {
            Log result;
            WeakReference<Log> ref = this.logs.get(key);
            if (ref != null && (result = (Log)ref.get()) != null) {
                return result;
            }
            result = this.newLog(name, bundleName);
            this.logs.put(key, new WeakReference<Log>(result));
            return result;
        }
    }

    protected AbstractLogFactory() {
    }

    protected abstract Log newLog(String var1, String var2);
}

