/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.spi;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.java.dev.vcc.api.CapabilityProfile;
import net.java.dev.vcc.api.Command;
import net.java.dev.vcc.api.Computer;
import net.java.dev.vcc.api.ComputerTemplate;
import net.java.dev.vcc.api.Datacenter;
import net.java.dev.vcc.api.DatacenterResourceGroup;
import net.java.dev.vcc.api.Host;
import net.java.dev.vcc.api.HostResourceGroup;
import net.java.dev.vcc.api.Log;
import net.java.dev.vcc.api.LogFactory;
import net.java.dev.vcc.api.ManagedObject;
import net.java.dev.vcc.api.ManagedObjectId;
import net.java.dev.vcc.spi.AbstractManagedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDatacenter
extends AbstractManagedObject<Datacenter>
implements Datacenter {
    private final Log log;
    private final Map<Class<? extends ManagedObject>, Set<Class<? extends Command>>> capabilities;

    public AbstractDatacenter(LogFactory logFactory, ManagedObjectId<Datacenter> id, Map.Entry<Class<? extends ManagedObject>, Set<Class<? extends Command>>> ... capabilities) {
        super(id);
        this.log = logFactory.getLog(this.getClass());
        HashMap<Class<? extends ManagedObject>, Set<Class<? extends Command>>> tmp = new HashMap<Class<? extends ManagedObject>, Set<Class<? extends Command>>>(capabilities.length);
        for (Map.Entry<Class<? extends ManagedObject>, Set<Class<? extends Command>>> capability : capabilities) {
            tmp.put(capability.getKey(), capability.getValue());
        }
        this.capabilities = Collections.unmodifiableMap(tmp);
    }

    public AbstractDatacenter(LogFactory logFactory, ManagedObjectId<Datacenter> id, CapabilityProfile base, Map.Entry<Class<? extends ManagedObject>, Set<Class<? extends Command>>> ... capabilities) {
        super(id);
        this.log = logFactory.getLog(this.getClass());
        HashMap<Class<? extends ManagedObject>, Set<Class<? extends Command>>> tmp = new HashMap<Class<? extends ManagedObject>, Set<Class<? extends Command>>>(capabilities.length);
        for (Map.Entry<Class<? extends ManagedObject>, Set<Class<? extends Command>>> capability : capabilities) {
            tmp.put(capability.getKey(), capability.getValue());
        }
        for (Class<? extends ManagedObject> moc : base.getObjectClasses()) {
            HashSet<Class<? extends Command>> foo = new HashSet<Class<? extends Command>>(base.getCommands(moc));
            if (tmp.containsKey(moc)) {
                foo.addAll((Collection)tmp.get(moc));
            }
            tmp.put(moc, Collections.unmodifiableSet(foo));
        }
        this.capabilities = Collections.unmodifiableMap(tmp);
    }

    public AbstractDatacenter(LogFactory logFactory, ManagedObjectId<Datacenter> id, boolean ignore, CapabilityProfile ... bases) {
        super(id);
        this.log = logFactory.getLog(this.getClass());
        HashMap<Class<? extends ManagedObject>, Set<Class<? extends Command>>> tmp = new HashMap<Class<? extends ManagedObject>, Set<Class<? extends Command>>>();
        for (CapabilityProfile base : bases) {
            for (Class<? extends ManagedObject> moc : base.getObjectClasses()) {
                HashSet<Class<? extends Command>> foo = new HashSet<Class<? extends Command>>(base.getCommands(moc));
                if (tmp.containsKey(moc)) {
                    foo.addAll((Collection)tmp.get(moc));
                }
                tmp.put(moc, Collections.unmodifiableSet(foo));
            }
        }
        this.capabilities = Collections.unmodifiableMap(tmp);
    }

    public final Log getLog() {
        return this.log;
    }

    protected static Map.Entry<Class<? extends ManagedObject>, Set<Class<? extends Command>>> with(Class<? extends ManagedObject> object, Class<? extends Command> ... commands) {
        return new AbstractMap.SimpleImmutableEntry<Class<? extends ManagedObject>, Set<Class<? extends Command>>>(object, Collections.unmodifiableSet(new HashSet<Class<? extends Command>>(Arrays.asList(commands))));
    }

    @Override
    public Set<ComputerTemplate> getComputerTemplates() {
        return Collections.emptySet();
    }

    @Override
    public Set<Host> getHosts() {
        return Collections.emptySet();
    }

    @Override
    public Set<DatacenterResourceGroup> getDatacenterResourceGroups() {
        return Collections.emptySet();
    }

    @Override
    public Set<Host> getAllHosts() {
        HashSet<Host> result = new HashSet<Host>(this.getHosts());
        for (DatacenterResourceGroup group : this.getDatacenterResourceGroups()) {
            result.addAll(group.getAllHosts());
        }
        return result;
    }

    @Override
    public Set<ComputerTemplate> getAllComputerTemplates() {
        HashSet<ComputerTemplate> result = new HashSet<ComputerTemplate>(this.getComputerTemplates());
        for (DatacenterResourceGroup group : this.getDatacenterResourceGroups()) {
            result.addAll(group.getAllComputerTemplates());
        }
        for (Host host : this.getHosts()) {
            result.addAll(host.getAllComputerTemplates());
        }
        return result;
    }

    @Override
    public Set<Computer> getAllComputers() {
        HashSet<Computer> result = new HashSet<Computer>();
        for (DatacenterResourceGroup group : this.getDatacenterResourceGroups()) {
            result.addAll(group.getAllComputers());
        }
        for (Host host : this.getHosts()) {
            result.addAll(host.getAllComputers());
        }
        return result;
    }

    @Override
    public Set<DatacenterResourceGroup> getAllDatacenterResourceGroups() {
        HashSet<DatacenterResourceGroup> result = new HashSet<DatacenterResourceGroup>(this.getDatacenterResourceGroups());
        for (DatacenterResourceGroup group : this.getDatacenterResourceGroups()) {
            result.addAll(group.getAllDatacenterResourceGroups());
        }
        return result;
    }

    @Override
    public Set<HostResourceGroup> getAllHostResourceGroups() {
        HashSet<HostResourceGroup> result = new HashSet<HostResourceGroup>();
        for (DatacenterResourceGroup group : this.getDatacenterResourceGroups()) {
            result.addAll(group.getAllHostResourceGroups());
        }
        for (Host host : this.getHosts()) {
            result.addAll(host.getAllHostResourceGroups());
        }
        return result;
    }

    @Override
    public final Set<Class<? extends Command>> getCommands(Class<? extends ManagedObject> managedObjectClass) {
        Set<Class<? extends Command>> result = this.capabilities.get(managedObjectClass);
        return result == null ? Collections.emptySet() : result;
    }

    @Override
    public final Set<Class<? extends ManagedObject>> getObjectClasses() {
        return this.capabilities.keySet();
    }

    @Override
    public final boolean supports(CapabilityProfile that) {
        if (this == that) {
            return true;
        }
        if (!that.getObjectClasses().containsAll(this.capabilities.keySet())) {
            return false;
        }
        for (Class<? extends ManagedObject> b : that.getObjectClasses()) {
            if (that.getCommands(b).containsAll((Collection)this.capabilities.get(b))) continue;
            return false;
        }
        return true;
    }
}

