/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.impl.vmware.esx;

import com.vmware.vim25.ManagedObjectReference;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import net.java.dev.vcc.api.ManagedObject;
import net.java.dev.vcc.api.ManagedObjectId;
import net.java.dev.vcc.impl.vmware.esx.ViDatacenterId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ViManagedObjectId<T extends ManagedObject>
extends ManagedObjectId<T> {
    private transient ManagedObjectReference moRef;
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("type", String.class), new ObjectStreamField("value", String.class)};

    public ViManagedObjectId(Class<T> managedObjectClass, ViDatacenterId datacenterId, ManagedObjectReference mo) {
        super(managedObjectClass, datacenterId.getDatacenterUrl());
        this.moRef = mo;
    }

    ManagedObjectReference getMORef() {
        return this.moRef;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("type", this.moRef.getType());
        fields.put("value", this.moRef.getValue());
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        this.moRef = new ManagedObjectReference();
        this.moRef.setType((String)fields.get("type", null));
        this.moRef.setValue((String)fields.get("value", null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ViManagedObjectId)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ViManagedObjectId that = (ViManagedObjectId)((Object)o);
        return this.moRef.equals(that.moRef);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.moRef.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        try {
            sb.append(";type=");
            sb.append(URLEncoder.encode(this.moRef.getType(), "UTF-8"));
            sb.append(";value=");
            sb.append(URLEncoder.encode(this.moRef.getValue(), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return sb.toString();
    }
}

