/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.impl.vmware.esx;

import com.vmware.vim25.Event;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ResourcePoolEvent;
import com.vmware.vim25.TaskEvent;
import com.vmware.vim25.VmEvent;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import net.java.dev.vcc.api.Log;
import net.java.dev.vcc.api.LogFactory;
import net.java.dev.vcc.impl.vmware.esx.ViClosingConnectionEvent;
import net.java.dev.vcc.impl.vmware.esx.ViDatacenter;
import net.java.dev.vcc.impl.vmware.esx.ViEventReceiver;
import net.java.dev.vcc.spi.AbstractManagedObject;

final class ViEventDispatcher
implements Runnable {
    private ViDatacenter viDatacenter;
    private final Log log;

    public ViEventDispatcher(ViDatacenter viDatacenter, LogFactory logFactory) {
        this.viDatacenter = viDatacenter;
        this.log = logFactory.getLog(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.log.debug("Event dispatcher thread started.");
        try {
            while (!this.viDatacenter.isClosing()) {
                Event event = this.viDatacenter.getEventCollector().poll();
                if (null == event) continue;
                if (event instanceof ViClosingConnectionEvent) {
                    this.log.debug("Received connection closing event");
                    break;
                }
                this.log.debug("Received event: {0}", new Object[]{event.getClass()});
                ManagedObjectReference ref = null;
                if (event instanceof VmEvent) {
                    ref = event.getVm().getVm();
                } else if (event instanceof ResourcePoolEvent) {
                    ref = ((ResourcePoolEvent)event).getResourcePool().getResourcePool();
                } else if (event instanceof TaskEvent) {
                    this.viDatacenter.processTask((TaskEvent)event);
                }
                if (ref == null) continue;
                AbstractManagedObject managedObject = this.viDatacenter.getManagedObject(ref);
                if (managedObject instanceof ViEventReceiver) {
                    ((ViEventReceiver)managedObject).receiveEvent(event);
                    continue;
                }
                if (managedObject != null) continue;
            }
        }
        finally {
            this.log.debug("Event dispatcher thread stopped.");
        }
    }

    public static String toString(Object bean) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        if (bean == null) {
            return "null";
        }
        if (bean.getClass().getPackage().getName().startsWith("java")) {
            return bean.toString();
        }
        StringBuilder buf = new StringBuilder(bean.getClass().getSimpleName());
        try {
            buf.append('@');
            buf.append(bean.hashCode());
            buf.append("[\n");
            for (PropertyDescriptor pd : Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors()) {
                boolean first;
                Object[] a;
                if (pd.getReadMethod() == null || Modifier.isStatic(pd.getReadMethod().getModifiers()) || "getClass".equals(pd.getReadMethod().getName())) continue;
                buf.append("    ");
                buf.append(pd.getName());
                buf.append(" = ");
                Object o = pd.getReadMethod().invoke(bean, new Object[0]);
                if (o == null) {
                    buf.append("null");
                } else if (o.getClass().isArray()) {
                    if (o instanceof byte[]) {
                        buf.append(Arrays.toString((byte[])o));
                    } else if (o instanceof boolean[]) {
                        buf.append(Arrays.toString((boolean[])o));
                    } else if (o instanceof char[]) {
                        buf.append(Arrays.toString((char[])o));
                    } else if (o instanceof double[]) {
                        buf.append(Arrays.toString((double[])o));
                    } else if (o instanceof float[]) {
                        buf.append(Arrays.toString((float[])o));
                    } else if (o instanceof int[]) {
                        buf.append(Arrays.toString((int[])o));
                    } else if (o instanceof long[]) {
                        buf.append(Arrays.toString((long[])o));
                    } else if (o instanceof short[]) {
                        buf.append(Arrays.toString((short[])o));
                    } else {
                        a = (Object[])o;
                        buf.append("[");
                        first = true;
                        for (Object i : a) {
                            if (first) {
                                first = false;
                                buf.append("\n        ");
                            } else {
                                buf.append(",\n        ");
                            }
                            buf.append(ViEventDispatcher.toString(i).replace("\n", "\n        "));
                        }
                        buf.append("]");
                        if (!first) {
                            buf.append('\n');
                        }
                    }
                } else if (o instanceof Collection) {
                    a = (Collection)o;
                    buf.append("[");
                    first = true;
                    for (Object e : a) {
                        if (first) {
                            first = false;
                            buf.append("\n        ");
                        } else {
                            buf.append(",\n        ");
                        }
                        buf.append(ViEventDispatcher.toString(e).replace("\n", "\n        "));
                    }
                    buf.append("]");
                    if (!first) {
                        buf.append('\n');
                    }
                } else if (o instanceof Map) {
                    a = (Map)o;
                    buf.append("[");
                    first = true;
                    for (Map.Entry entry : a.entrySet()) {
                        if (first) {
                            first = false;
                        } else {
                            buf.append(",\n        ");
                        }
                        buf.append(ViEventDispatcher.toString(entry.getKey()).replace("\n", "\n            "));
                        buf.append("->");
                        buf.append(ViEventDispatcher.toString(entry.getValue()).replace("\n", "\n            "));
                    }
                    buf.append("]");
                } else if (o.getClass().getPackage().getName().startsWith("java")) {
                    buf.append(o);
                } else {
                    buf.append(ViEventDispatcher.toString(o).replace("\n", "\n    "));
                }
                buf.append("\n");
            }
        }
        catch (Throwable t) {
            buf.append("\n    *** Threw exception while processing ***\n");
            StringWriter sw = new StringWriter();
            try {
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                pw.close();
                sw.close();
            }
            catch (IOException e) {
                throw new RuntimeException("This should never happen", e);
            }
            buf.append(sw.toString());
        }
        buf.append("]");
        return buf.toString();
    }
}

