/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.impl.vmware.esx;

import com.vmware.vim25.Event;
import com.vmware.vim25.EventFilterSpec;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.java.dev.vcc.api.Log;
import net.java.dev.vcc.api.LogFactory;
import net.java.dev.vcc.impl.vmware.esx.ViClosingConnectionEvent;
import net.java.dev.vcc.impl.vmware.esx.ViDatacenter;

final class ViEventCollector
implements Runnable {
    private final ManagedObjectReference eventHistoryCollector;
    private final Queue<Event> events = new ConcurrentLinkedQueue<Event>();
    private ViDatacenter viDatacenter;
    private final Log log;

    public ViEventCollector(ViDatacenter viDatacenter, LogFactory logFactory) throws RuntimeFaultFaultMsg, InvalidStateFaultMsg {
        this.viDatacenter = viDatacenter;
        this.log = logFactory.getLog(this.getClass());
        this.eventHistoryCollector = viDatacenter.getConnection().getProxy().createCollectorForEvents(viDatacenter.getConnection().getServiceContent().getEventManager(), new EventFilterSpec());
        viDatacenter.getConnection().getProxy().resetCollector(this.eventHistoryCollector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block7: {
            this.log.debug("Starting collecting events");
            try {
                boolean finished = false;
                while (!this.viDatacenter.isClosing() && !finished) {
                    List events;
                    try {
                        events = this.viDatacenter.getConnection().getProxy().readNextEvents(this.eventHistoryCollector, 100);
                    }
                    catch (RuntimeFaultFaultMsg e) {
                        this.log.error((Throwable)e, e.getMessage());
                        this.log.debug("Finished collecting events. Currently there are {0} events in the queue.", new Object[]{this.events.size()});
                        return;
                    }
                    if (events.isEmpty()) {
                        finished = true;
                        continue;
                    }
                    this.events.addAll(events);
                }
                if (!this.viDatacenter.isClosing() || !finished) break block7;
                this.events.add(new ViClosingConnectionEvent());
            }
            catch (Throwable throwable) {
                this.log.debug("Finished collecting events. Currently there are {0} events in the queue.", new Object[]{this.events.size()});
                throw throwable;
            }
        }
        this.log.debug("Finished collecting events. Currently there are {0} events in the queue.", new Object[]{this.events.size()});
    }

    public Event poll() {
        return this.events.poll();
    }
}

