/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.impl.vmware.esx;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import net.java.dev.vcc.api.Command;
import net.java.dev.vcc.api.ComputerTemplate;
import net.java.dev.vcc.api.DatacenterResourceGroup;
import net.java.dev.vcc.api.Host;
import net.java.dev.vcc.api.ManagedObjectId;
import net.java.dev.vcc.impl.vmware.esx.ViComputerTemplate;
import net.java.dev.vcc.impl.vmware.esx.ViComputerTemplateId;
import net.java.dev.vcc.impl.vmware.esx.ViDatacenter;
import net.java.dev.vcc.impl.vmware.esx.ViDatacenterResourceGroupId;
import net.java.dev.vcc.impl.vmware.esx.ViHost;
import net.java.dev.vcc.impl.vmware.esx.ViHostId;
import net.java.dev.vcc.spi.AbstractDatacenterResourceGroup;
import net.java.dev.vcc.util.CompletedFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ViDatacenterResourceGroup
extends AbstractDatacenterResourceGroup {
    private final ViDatacenter datacenter;
    private ViDatacenterResourceGroup parent;
    private String name;
    private final Map<ViHostId, ViHost> hosts = Collections.synchronizedMap(new HashMap());
    private final Map<ViComputerTemplateId, ViComputerTemplate> templates = Collections.synchronizedMap(new HashMap());
    private final Map<ViDatacenterResourceGroupId, ViDatacenterResourceGroup> resourceGroups = Collections.synchronizedMap(new HashMap());

    ViDatacenterResourceGroup(ViDatacenter datacenter, ManagedObjectId<DatacenterResourceGroup> id, ViDatacenterResourceGroup parent, String name) {
        super(id);
        this.datacenter = datacenter;
        this.parent = parent;
        this.name = name;
    }

    public Set<Class<? extends Command>> getCommands() {
        return Collections.emptySet();
    }

    public <T extends Command> T execute(T command) {
        command.setSubmitted((Future)new CompletedFuture("Unsupported command", (Throwable)new UnsupportedOperationException()));
        return command;
    }

    public Set<DatacenterResourceGroup> getDatacenterResourceGroups() {
        return Collections.unmodifiableSet(new HashSet<ViDatacenterResourceGroup>(this.resourceGroups.values()));
    }

    public Set<Host> getHosts() {
        return Collections.unmodifiableSet(new HashSet<ViHost>(this.hosts.values()));
    }

    public Set<ComputerTemplate> getComputerTemplates() {
        return Collections.unmodifiableSet(new HashSet<ViComputerTemplate>(this.templates.values()));
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    void setParent(ViDatacenterResourceGroup parent) {
        this.parent = parent;
    }

    void addHost(ViHost viHost) {
        this.hosts.put(viHost.getId(), viHost);
    }

    void removeHost(ViHost viHost) {
        this.hosts.remove((Object)viHost.getId());
    }

    public void addResourceGroup(ViDatacenterResourceGroup viResourceGroup) {
        this.resourceGroups.put(viResourceGroup.getId(), viResourceGroup);
    }

    public void removeResourceGroup(ViDatacenterResourceGroup viResourceGroup) {
        this.resourceGroups.remove((Object)viResourceGroup.getId());
    }

    public void addComputerTemplate(ViComputerTemplate computerTemplate) {
        this.templates.put(computerTemplate.getId(), computerTemplate);
    }

    public void removeComputerTemplate(ViComputerTemplate computerTemplate) {
        this.templates.remove((Object)computerTemplate.getId());
    }

    public ViDatacenterResourceGroupId getId() {
        return (ViDatacenterResourceGroupId)super.getId();
    }
}

