/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.impl.vmware.esx;

import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.TaskEvent;
import com.vmware.vim25.TaskInfo;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.VirtualMachineSnapshotInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.java.dev.vcc.api.CapabilityProfile;
import net.java.dev.vcc.api.Command;
import net.java.dev.vcc.api.Computer;
import net.java.dev.vcc.api.DatacenterResourceGroup;
import net.java.dev.vcc.api.Host;
import net.java.dev.vcc.api.LogFactory;
import net.java.dev.vcc.api.ManagedObjectId;
import net.java.dev.vcc.api.PowerState;
import net.java.dev.vcc.api.profiles.BasicProfile;
import net.java.dev.vcc.impl.vmware.esx.ViComputer;
import net.java.dev.vcc.impl.vmware.esx.ViComputerId;
import net.java.dev.vcc.impl.vmware.esx.ViComputerTemplate;
import net.java.dev.vcc.impl.vmware.esx.ViComputerTemplateId;
import net.java.dev.vcc.impl.vmware.esx.ViConnection;
import net.java.dev.vcc.impl.vmware.esx.ViDatacenterId;
import net.java.dev.vcc.impl.vmware.esx.ViDatacenterResourceGroup;
import net.java.dev.vcc.impl.vmware.esx.ViDatacenterResourceGroupId;
import net.java.dev.vcc.impl.vmware.esx.ViEventCollector;
import net.java.dev.vcc.impl.vmware.esx.ViEventDispatcher;
import net.java.dev.vcc.impl.vmware.esx.ViHost;
import net.java.dev.vcc.impl.vmware.esx.ViHostId;
import net.java.dev.vcc.impl.vmware.esx.ViHostResourceGroup;
import net.java.dev.vcc.impl.vmware.esx.ViHostResourceGroupId;
import net.java.dev.vcc.impl.vmware.esx.ViTaskCollector;
import net.java.dev.vcc.impl.vmware.esx.ViTaskContinuation;
import net.java.dev.vcc.impl.vmware.esx.vim25.Helper;
import net.java.dev.vcc.spi.AbstractDatacenter;
import net.java.dev.vcc.spi.AbstractManagedObject;
import net.java.dev.vcc.util.CompletedFuture;
import net.java.dev.vcc.util.DefaultPollingTask;
import net.java.dev.vcc.util.TaskController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ViDatacenter
extends AbstractDatacenter {
    private final TaskController taskController = new ViTaskController();
    private final Lock connectionLock = new ReentrantLock();
    private boolean connectionClosing = false;
    private final Condition closingCondition = this.connectionLock.newCondition();
    private final Condition closedCondition = this.connectionLock.newCondition();
    private ViConnection connection;
    private final ExecutorService connectionExecutor;
    private final Map<ViHostId, ViHost> hosts = Collections.synchronizedMap(new HashMap());
    private final Map<ViDatacenterResourceGroupId, ViDatacenterResourceGroup> resourceGroups = Collections.synchronizedMap(new HashMap());
    private final Map<String, AbstractManagedObject> model = Collections.synchronizedMap(new HashMap());
    private final ViEventCollector eventCollector;
    private ManagedObjectReference rootFolder;
    private final ViEventDispatcher eventDispatcher;
    private final ViTaskCollector taskCollector;
    private ConcurrentMap<String, ViTaskContinuation<?>> pendingTasks = new ConcurrentHashMap();

    ViDatacenter(ViDatacenterId id, ViConnection connection, LogFactory logFactory, ExecutorService executorService) throws RuntimeFaultFaultMsg, InvalidStateFaultMsg, InvalidPropertyFaultMsg {
        super(logFactory, (ManagedObjectId)id, (CapabilityProfile)BasicProfile.getInstance(), new Map.Entry[0]);
        this.connection = connection;
        this.connectionExecutor = executorService;
        this.getLog().debug("Starting event collector");
        this.eventDispatcher = new ViEventDispatcher(this, logFactory);
        this.eventCollector = new ViEventCollector(this, logFactory);
        this.taskCollector = new ViTaskCollector(this, logFactory);
        this.connectionExecutor.submit((Runnable)new DefaultPollingTask(this.taskController, (Runnable)this.eventCollector, 1L, TimeUnit.SECONDS));
        try {
            this.getLog().debug("Getting datacenter inventory");
            TraversalSpec folderTraversalSpec = Helper.newTraversalSpec("folderTraversalSpec", "Folder", "childEntity", false, new SelectionSpec[]{Helper.newSelectionSpec("folderTraversalSpec"), Helper.newTraversalSpec("datacenterHostTraversalSpec", "Datacenter", "hostFolder", false, Helper.newSelectionSpec("folderTraversalSpec")), Helper.newTraversalSpec("datacenterVmTraversalSpec", "Datacenter", "vmFolder", false, Helper.newSelectionSpec("folderTraversalSpec")), Helper.newTraversalSpec("computeResourceRpTraversalSpec", "ComputeResource", "resourcePool", false, Helper.newSelectionSpec("resourcePoolTraversalSpec")), Helper.newTraversalSpec("computeResourceHostTraversalSpec", "ComputeResource", "host", false, new SelectionSpec[0]), Helper.newTraversalSpec("resourcePoolTraversalSpec", "ResourcePool", "resourcePool", false, Helper.newSelectionSpec("resourcePoolTraversalSpec"))});
            this.rootFolder = connection.getServiceContent().getRootFolder();
            PropertyFilterSpec spec = Helper.newPropertyFilterSpec(new PropertySpec[]{Helper.newPropertySpec("ManagedEntity", false, "name"), Helper.newPropertySpec("ManagedEntity", false, "parent"), Helper.newPropertySpec("VirtualMachine", false, "resourcePool"), Helper.newPropertySpec("VirtualMachine", false, "config"), Helper.newPropertySpec("VirtualMachine", false, "runtime"), Helper.newPropertySpec("VirtualMachine", false, "snapshot")}, new ObjectSpec[]{Helper.newObjectSpec(this.rootFolder, false, new SelectionSpec[]{folderTraversalSpec})});
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put(this.rootFolder.getValue(), (Object)this);
            HashMap<String, ArrayList<ViHost>> waiting = new HashMap<String, ArrayList<ViHost>>();
            HashMap<String, String> proxyParents = new HashMap<String, String>();
            List entities = connection.getProxy().retrieveProperties(connection.getServiceContent().getPropertyCollector(), Collections.singletonList(spec));
            this.getLog().debug("Building model from inventory");
            for (ObjectContent entity : entities) {
                Collection _waiting;
                ManagedObjectReference parent;
                Object entityMO;
                ManagedObjectReference entityObject = entity.getObj();
                if (model.containsKey(entityObject.getValue())) continue;
                String entityType = entityObject.getType();
                String entityName = (String)Helper.getDynamicProperty(entity, "name");
                if ("VirtualMachine".equals(entityType)) {
                    VirtualMachineConfigInfo config = (VirtualMachineConfigInfo)Helper.getDynamicProperty(entity, "config");
                    VirtualMachineRuntimeInfo runtime = (VirtualMachineRuntimeInfo)Helper.getDynamicProperty(entity, "runtime");
                    VirtualMachineSnapshotInfo snapshot = (VirtualMachineSnapshotInfo)Helper.getDynamicProperty(entity, "snapshot");
                    entityMO = config != null && config.isTemplate() ? new ViComputerTemplate(this, new ViComputerTemplateId(this.getId(), entityObject), null, entityName, config, runtime, snapshot) : new ViComputer(this, new ViComputerId(this.getId(), entityObject), null, entityName, config, runtime, snapshot);
                } else if ("ComputeResource".equals(entityType)) {
                    entityMO = new ViHost(this, new ViHostId(this.getId(), entityObject), null, entityName);
                } else if ("ResourcePool".equals(entityType)) {
                    entityMO = new ViHostResourceGroup(this, new ViHostResourceGroupId(this.getId(), entityObject), null, entityName);
                } else if ("Folder".equals(entityType)) {
                    parent = (ManagedObjectReference)Helper.getDynamicProperty(entity, "parent");
                    if (parent != null && "Datacenter".equals(parent.getType())) {
                        proxyParents.put(entityObject.getValue(), parent.getValue());
                        continue;
                    }
                    entityMO = new ViDatacenterResourceGroup(this, new ViDatacenterResourceGroupId(this.getId(), entityObject), null, entityName);
                } else {
                    if (!"Datacenter".equals(entityType)) continue;
                    entityMO = new ViDatacenterResourceGroup(this, new ViDatacenterResourceGroupId(this.getId(), entityObject), null, entityName);
                }
                parent = (ManagedObjectReference)Helper.getDynamicProperty(entity, "resourcePool");
                if (parent == null) {
                    parent = (ManagedObjectReference)Helper.getDynamicProperty(entity, "parent");
                }
                if (parent != null) {
                    AbstractManagedObject parentMO = proxyParents.containsKey(parent.getValue()) ? (AbstractManagedObject)model.get(proxyParents.get(parent.getValue())) : (AbstractManagedObject)model.get(parent.getValue());
                    if (parentMO != null) {
                        this.addChildMO(parentMO, (AbstractManagedObject)entityMO);
                    } else {
                        ArrayList<ViHost> pendingChildMOs = (ArrayList<ViHost>)waiting.get(parent.getValue());
                        if (pendingChildMOs == null) {
                            pendingChildMOs = new ArrayList<ViHost>();
                            waiting.put(parent.getValue(), pendingChildMOs);
                        }
                        pendingChildMOs.add((ViHost)((Object)entityMO));
                    }
                }
                if ((_waiting = (Collection)waiting.get(entityObject.getValue())) != null) {
                    for (AbstractManagedObject childMO : _waiting) {
                        this.addChildMO((AbstractManagedObject)entityMO, childMO);
                    }
                    waiting.remove(entityObject.getValue());
                }
                model.put(entityObject.getValue(), entityMO);
            }
            this.model.putAll(model);
            Iterator it = waiting.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry waitingMOs = it.next();
                if (!proxyParents.containsKey(waitingMOs.getKey())) continue;
                if (proxyParents.containsKey(waitingMOs.getKey())) {
                    AbstractManagedObject parentMO = (AbstractManagedObject)model.get(proxyParents.get(waitingMOs.getKey()));
                    for (AbstractManagedObject childMO : (Collection)waitingMOs.getValue()) {
                        this.addChildMO(parentMO, childMO);
                    }
                }
                it.remove();
            }
            if (waiting.isEmpty()) {
                this.getLog().debug("Datacenter model constructed successfully");
            } else {
                this.getLog().warn("Datacenter model is not complete: {0} parents were referenced from the inventory but not provided in the inventory", new Object[]{waiting.size()});
            }
            this.getLog().debug("Starting event dispatcher");
            this.connectionExecutor.submit(this.eventDispatcher);
            this.connectionExecutor.submit((Runnable)new DefaultPollingTask(this.taskController, (Runnable)this.taskCollector, 1L, TimeUnit.SECONDS));
        }
        catch (RuntimeException e) {
            this.close();
            throw e;
        }
        catch (RuntimeFaultFaultMsg e) {
            this.close();
            throw e;
        }
        catch (InvalidPropertyFaultMsg e) {
            this.close();
            throw e;
        }
        this.getLog().debug("Datacenter created");
    }

    private void addChildMO(AbstractManagedObject parentMO, AbstractManagedObject childMO) {
        if (parentMO instanceof ViHostResourceGroup) {
            if (childMO instanceof ViComputer) {
                ((ViHostResourceGroup)parentMO).addComputer((ViComputer)childMO);
            } else if (childMO instanceof ViHostResourceGroup) {
                ((ViHostResourceGroup)parentMO).addHostResourceGroup((ViHostResourceGroup)childMO);
            }
        } else if (parentMO instanceof ViHost) {
            if (childMO instanceof ViComputer) {
                ((ViHost)parentMO).addComputer((ViComputer)childMO);
            } else if (childMO instanceof ViHostResourceGroup) {
                ((ViHost)parentMO).addHostResourceGroup((ViHostResourceGroup)childMO);
            }
        } else if (parentMO instanceof ViDatacenterResourceGroup) {
            if (childMO instanceof ViHost) {
                ((ViDatacenterResourceGroup)parentMO).addHost((ViHost)childMO);
            } else if (childMO instanceof ViDatacenterResourceGroup) {
                ((ViDatacenterResourceGroup)parentMO).addResourceGroup((ViDatacenterResourceGroup)childMO);
            } else if (childMO instanceof ViComputerTemplate) {
                ((ViDatacenterResourceGroup)parentMO).addComputerTemplate((ViComputerTemplate)childMO);
            }
        } else if (parentMO instanceof ViDatacenter) {
            if (childMO instanceof ViDatacenterResourceGroup) {
                ((ViDatacenter)parentMO).addDatacenterResourceGroup((ViDatacenterResourceGroup)childMO);
            } else if (childMO instanceof ViHost) {
                ((ViDatacenter)parentMO).addHost((ViHost)childMO);
            }
        }
    }

    void addHost(ViHost viHost) {
        this.hosts.put(viHost.getId(), viHost);
    }

    void removeHost(ViHost viHost) {
        this.hosts.remove((Object)viHost.getId());
    }

    public void addDatacenterResourceGroup(ViDatacenterResourceGroup viResourceGroup) {
        this.resourceGroups.put(viResourceGroup.getId(), viResourceGroup);
    }

    public void removeResourceGroup(ViDatacenterResourceGroup viResourceGroup) {
        this.resourceGroups.remove((Object)viResourceGroup.getId());
    }

    public Set<Class<? extends Command>> getCommands() {
        return Collections.emptySet();
    }

    public <T extends Command> T execute(T command) {
        command.setSubmitted((Future)new CompletedFuture("Unsupported command", (Throwable)new UnsupportedOperationException()));
        return command;
    }

    public String getName() {
        return this.getId().getDatacenterUrl();
    }

    public Set<Host> getHosts() {
        return Collections.unmodifiableSet(new HashSet<ViHost>(this.hosts.values()));
    }

    public Set<DatacenterResourceGroup> getDatacenterResourceGroups() {
        return Collections.unmodifiableSet(new HashSet<ViDatacenterResourceGroup>(this.resourceGroups.values()));
    }

    public Set<Computer> getComputers() {
        HashSet result = new HashSet();
        for (Host host : this.getHosts()) {
            result.addAll(host.getComputers());
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<PowerState> getAllowedStates() {
        return ResourceHolder.ALLOWED_TRANSITIONS.keySet();
    }

    public Set<PowerState> getAllowedStates(PowerState from) {
        Set states = (Set)ResourceHolder.ALLOWED_TRANSITIONS.get(from);
        if (states != null) {
            return states;
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.connectionLock.lock();
        try {
            if (this.connectionClosing) {
                return;
            }
            this.connectionClosing = true;
            this.closingCondition.signalAll();
        }
        finally {
            this.connectionLock.unlock();
        }
        this.connectionLock.lock();
        try {
            try {
                this.connectionExecutor.shutdown();
                this.connection.getProxy().logout(this.connection.getSessionManager());
            }
            catch (RuntimeFaultFaultMsg e) {
                e.printStackTrace();
            }
            finally {
                this.connection = null;
                this.connectionExecutor.shutdownNow();
            }
        }
        finally {
            this.closedCondition.signalAll();
            this.connectionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        this.connectionLock.lock();
        try {
            boolean bl = this.connection != null && !this.connectionClosing;
            return bl;
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosing() {
        this.connectionLock.lock();
        try {
            boolean bl = this.connectionClosing;
            return bl;
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitClosed() throws InterruptedException {
        this.connectionLock.lock();
        try {
            while (this.isOpen()) {
                this.closedCondition.await();
            }
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean awaitClosed(long timeout, TimeUnit unit) throws InterruptedException {
        this.connectionLock.lock();
        try {
            long nanosTimeout = unit.toNanos(timeout);
            while (this.isOpen()) {
                if (nanosTimeout > 0L) {
                    nanosTimeout = this.closedCondition.awaitNanos(nanosTimeout);
                    continue;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitClosing() throws InterruptedException {
        this.connectionLock.lock();
        try {
            while (!this.isClosing()) {
                this.closedCondition.await();
            }
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean awaitClosing(long timeout, TimeUnit unit) throws InterruptedException {
        this.connectionLock.lock();
        try {
            long nanosTimeout = unit.toNanos(timeout);
            while (!this.isClosing()) {
                if (nanosTimeout > 0L) {
                    nanosTimeout = this.closedCondition.awaitNanos(nanosTimeout);
                    continue;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    ViConnection getConnection() {
        return this.connection;
    }

    public ViEventCollector getEventCollector() {
        return this.eventCollector;
    }

    public AbstractManagedObject getManagedObject(ManagedObjectReference value) {
        return this.model.get(value.getValue());
    }

    <T> Future<T> addPendingTask(ManagedObjectReference moRef, ViTaskContinuation<T> c) {
        this.pendingTasks.put(moRef.getValue(), c);
        return c.getFuture();
    }

    void processTask(TaskEvent taskEvent) {
        this.processTask(taskEvent.getInfo());
    }

    public void processTask(TaskInfo taskInfo) {
        ViTaskContinuation continuation = (ViTaskContinuation)this.pendingTasks.get(taskInfo.getTask().getValue());
        if (continuation != null) {
            switch (taskInfo.getState()) {
                case SUCCESS: {
                    continuation.onSuccess();
                    this.pendingTasks.remove(taskInfo.getTask().getValue());
                    break;
                }
                case ERROR: {
                    continuation.onError(taskInfo.getError());
                    this.pendingTasks.remove(taskInfo.getTask().getValue());
                }
            }
        }
    }

    public ViDatacenterId getId() {
        return (ViDatacenterId)super.getId();
    }

    private final class ViTaskController
    implements TaskController {
        private ViTaskController() {
        }

        public boolean isActive() {
            return !ViDatacenter.this.isClosing();
        }

        public void awaitDeactivated() throws InterruptedException {
            ViDatacenter.this.awaitClosing();
        }

        public boolean awaitDeactivated(long timeout, TimeUnit unit) throws InterruptedException {
            return ViDatacenter.this.awaitClosing(timeout, unit);
        }
    }

    private static final class ResourceHolder {
        private static final Map<PowerState, Set<PowerState>> ALLOWED_TRANSITIONS;

        private ResourceHolder() {
        }

        static {
            TreeMap<PowerState, Set<PowerState>> map = new TreeMap<PowerState, Set<PowerState>>();
            map.put(PowerState.STOPPED, Collections.unmodifiableSet(new TreeSet<PowerState>(Arrays.asList(PowerState.RUNNING))));
            map.put(PowerState.SUSPENDED, Collections.unmodifiableSet(new TreeSet<PowerState>(Arrays.asList(PowerState.STOPPED, PowerState.RUNNING))));
            map.put(PowerState.RUNNING, Collections.unmodifiableSet(new TreeSet<PowerState>(Arrays.asList(PowerState.STOPPED, PowerState.SUSPENDED))));
            ALLOWED_TRANSITIONS = Collections.unmodifiableMap(map);
        }
    }
}

