/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.impl.vmware.esx;

import com.vmware.vim25.InvalidLocaleFaultMsg;
import com.vmware.vim25.InvalidLoginFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.UserSession;
import com.vmware.vim25.VimPortType;
import java.net.MalformedURLException;
import java.util.concurrent.ExecutorService;
import net.java.dev.vcc.impl.vmware.esx.vim25.ConnectionManager;

final class ViConnection {
    private final VimPortType proxy;
    private final ManagedObjectReference sessionManager;
    private final UserSession session;
    private final ManagedObjectReference serviceInstance;
    private final ServiceContent serviceContent;

    public ViConnection(String url, String username, char[] password, ExecutorService executor) throws MalformedURLException, RuntimeFaultFaultMsg, InvalidLocaleFaultMsg, InvalidLoginFaultMsg {
        this.proxy = ConnectionManager.getConnection(url, executor);
        this.serviceInstance = ConnectionManager.getServiceInstance();
        this.serviceContent = this.proxy.retrieveServiceContent(this.serviceInstance);
        this.sessionManager = this.serviceContent.getSessionManager();
        this.session = this.proxy.login(this.sessionManager, username, new String(password), null);
    }

    public VimPortType getProxy() {
        return this.proxy;
    }

    public ManagedObjectReference getSessionManager() {
        return this.sessionManager;
    }

    public UserSession getSession() {
        return this.session;
    }

    public ManagedObjectReference getServiceInstance() {
        return this.serviceInstance;
    }

    public ServiceContent getServiceContent() {
        return this.serviceContent;
    }
}

