/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.impl.vmware.esx;

import com.vmware.vim25.Event;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.VirtualMachineSnapshotInfo;
import com.vmware.vim25.VmPoweredOffEvent;
import com.vmware.vim25.VmPoweredOnEvent;
import com.vmware.vim25.VmReconfiguredEvent;
import com.vmware.vim25.VmResourcePoolMovedEvent;
import com.vmware.vim25.VmResumingEvent;
import com.vmware.vim25.VmStartingEvent;
import com.vmware.vim25.VmStoppingEvent;
import com.vmware.vim25.VmSuspendedEvent;
import com.vmware.vim25.VmSuspendingEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import net.java.dev.vcc.api.Command;
import net.java.dev.vcc.api.Computer;
import net.java.dev.vcc.api.ComputerSnapshot;
import net.java.dev.vcc.api.Host;
import net.java.dev.vcc.api.ManagedObjectId;
import net.java.dev.vcc.api.PowerState;
import net.java.dev.vcc.api.Success;
import net.java.dev.vcc.api.commands.RestartComputer;
import net.java.dev.vcc.api.commands.StartComputer;
import net.java.dev.vcc.api.commands.StopComputer;
import net.java.dev.vcc.api.commands.SuspendComputer;
import net.java.dev.vcc.impl.vmware.esx.ViComputerId;
import net.java.dev.vcc.impl.vmware.esx.ViDatacenter;
import net.java.dev.vcc.impl.vmware.esx.ViDatacenterResourceGroup;
import net.java.dev.vcc.impl.vmware.esx.ViEventReceiver;
import net.java.dev.vcc.impl.vmware.esx.ViHost;
import net.java.dev.vcc.impl.vmware.esx.ViHostResourceGroup;
import net.java.dev.vcc.impl.vmware.esx.ViTaskContinuation;
import net.java.dev.vcc.spi.AbstractComputer;
import net.java.dev.vcc.spi.AbstractManagedObject;
import net.java.dev.vcc.util.CompletedFuture;
import net.java.dev.vcc.util.FutureReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ViComputer
extends AbstractComputer
implements ViEventReceiver {
    private final ViDatacenter datacenter;
    private final Object lock = new Object();
    private ViDatacenterResourceGroup parent;
    private String name;
    private VirtualMachineConfigInfo config;
    private VirtualMachineRuntimeInfo runtime;
    private VirtualMachineSnapshotInfo snapshot;
    private FutureReference<PowerState> futureState = null;

    ViComputer(ViDatacenter datacenter, ManagedObjectId<Computer> id, ViDatacenterResourceGroup parent, String name, VirtualMachineConfigInfo config, VirtualMachineRuntimeInfo runtime, VirtualMachineSnapshotInfo snapshot) {
        super(id);
        this.datacenter = datacenter;
        this.parent = parent;
        this.name = name;
        this.config = config;
        this.runtime = runtime;
        this.snapshot = snapshot;
    }

    public Set<Class<? extends Command>> getCommands() {
        ArrayList<Class<StopComputer>> classes = new ArrayList<Class<StopComputer>>();
        switch (this.getState()) {
            case STOPPED: {
                classes.add(StartComputer.class);
                break;
            }
            case SUSPENDED: {
                classes.add(StartComputer.class);
                classes.add(StopComputer.class);
                break;
            }
            case RUNNING: {
                classes.add(SuspendComputer.class);
                classes.add(RestartComputer.class);
                classes.add(StopComputer.class);
            }
        }
        return Collections.unmodifiableSet(new HashSet(classes));
    }

    public <T extends Command> T execute(T command) {
        try {
            if (command instanceof StartComputer) {
                command.setSubmitted(this.datacenter.addPendingTask(this.datacenter.getConnection().getProxy().powerOnVMTask(this.getId().getMORef(), null), new SetPowerStateOnSuccess(VirtualMachinePowerState.POWERED_ON)));
            } else if (command instanceof StopComputer) {
                command.setSubmitted(this.datacenter.addPendingTask(this.datacenter.getConnection().getProxy().powerOffVMTask(this.getId().getMORef()), new SetPowerStateOnSuccess(VirtualMachinePowerState.POWERED_OFF)));
            } else if (command instanceof SuspendComputer) {
                command.setSubmitted(this.datacenter.addPendingTask(this.datacenter.getConnection().getProxy().suspendVMTask(this.getId().getMORef()), new SetPowerStateOnSuccess(VirtualMachinePowerState.SUSPENDED)));
            } else {
                command.setSubmitted((Future)new CompletedFuture("Unsupported command", (Throwable)new UnsupportedOperationException()));
            }
        }
        catch (Throwable e) {
            command.setSubmitted((Future)new CompletedFuture(e.getMessage(), e));
        }
        return command;
    }

    public Host getHost() {
        return null;
    }

    public boolean isHostChanging() {
        return false;
    }

    public Future<Host> getFutureHost() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PowerState getState() {
        Object object = this.lock;
        synchronized (object) {
            if (this.runtime == null || this.runtime.getPowerState() == null) {
                return PowerState.STOPPED;
            }
            switch (this.runtime.getPowerState()) {
                case POWERED_OFF: {
                    return PowerState.STOPPED;
                }
                case POWERED_ON: {
                    return PowerState.RUNNING;
                }
                case SUSPENDED: {
                    return PowerState.SUSPENDED;
                }
            }
            return PowerState.STOPPED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStateChanging() {
        Object object = this.lock;
        synchronized (object) {
            if (this.futureState == null) {
                return false;
            }
            if (this.futureState.isDone()) {
                this.futureState = null;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<PowerState> getFutureState() {
        Object object = this.lock;
        synchronized (object) {
            return this.futureState == null ? new CompletedFuture((Object)this.getState()) : this.futureState;
        }
    }

    public Set<ComputerSnapshot> getSnapshots() {
        return Collections.emptySet();
    }

    public Set<Host> getAllowedHosts() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Object object = this.lock;
        synchronized (object) {
            return this.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() {
        Object object = this.lock;
        synchronized (object) {
            return this.config == null ? null : this.config.getAnnotation();
        }
    }

    public ViComputerId getId() {
        return (ViComputerId)super.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setParent(ViDatacenterResourceGroup parent) {
        Object object = this.lock;
        synchronized (object) {
            this.parent = parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setName(String name) {
        Object object = this.lock;
        synchronized (object) {
            this.name = name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveEvent(Event event) {
        Object object = this.lock;
        synchronized (object) {
            if (event instanceof VmResourcePoolMovedEvent) {
                VmResourcePoolMovedEvent rpMoved = (VmResourcePoolMovedEvent)event;
                AbstractManagedObject oldParent = this.datacenter.getManagedObject(rpMoved.getOldParent().getResourcePool());
                AbstractManagedObject newParent = this.datacenter.getManagedObject(rpMoved.getOldParent().getResourcePool());
                if (oldParent instanceof ViHostResourceGroup) {
                    ((ViHostResourceGroup)oldParent).removeComputer(this);
                    this.datacenter.getLog().debug("Removing {0} from {1}", new Object[]{this, oldParent});
                } else if (oldParent instanceof ViHost) {
                    ((ViHost)oldParent).removeComputer(this);
                    this.datacenter.getLog().debug("Removing {0} from {1}", new Object[]{this, oldParent});
                } else {
                    this.datacenter.getLog().debug("No old parent");
                }
                if (newParent instanceof ViHostResourceGroup) {
                    ((ViHostResourceGroup)newParent).addComputer(this);
                    this.datacenter.getLog().debug("Adding {0} to {1}", new Object[]{this, newParent});
                } else if (newParent instanceof ViHost) {
                    ((ViHost)newParent).addComputer(this);
                    this.datacenter.getLog().debug("Adding {0} to {1}", new Object[]{this, newParent});
                } else {
                    this.datacenter.getLog().debug("No new parent");
                }
            } else if (event instanceof VmReconfiguredEvent) {
                VmReconfiguredEvent vmReconfiguredEvent = (VmReconfiguredEvent)event;
            } else if (event instanceof VmPoweredOnEvent) {
                this.setState(VirtualMachinePowerState.POWERED_ON);
            } else if (event instanceof VmPoweredOffEvent) {
                this.setState(VirtualMachinePowerState.POWERED_OFF);
            } else if (event instanceof VmSuspendedEvent) {
                this.setState(VirtualMachinePowerState.SUSPENDED);
            } else if (event instanceof VmSuspendingEvent || event instanceof VmResumingEvent || event instanceof VmStartingEvent || event instanceof VmStoppingEvent) {
                this.datacenter.getLog().debug("{0} is changing state", new Object[]{this});
                if (this.futureState == null || this.futureState.isDone()) {
                    this.futureState = new FutureReference();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(VirtualMachinePowerState state) {
        Object object = this.lock;
        synchronized (object) {
            if (this.runtime.getPowerState().equals((Object)state)) {
                return;
            }
            this.runtime.setPowerState(state);
            PowerState powerState = this.getState();
            if (this.futureState != null && !this.futureState.isDone()) {
                this.futureState.set((Object)powerState);
                this.futureState = null;
            }
            this.datacenter.getLog().info("{0} has changed state to {1}", new Object[]{this, powerState});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetPowerStateOnSuccess
    extends ViTaskContinuation<Success> {
        private final VirtualMachinePowerState newState;

        public SetPowerStateOnSuccess(VirtualMachinePowerState newState) {
            this.newState = newState;
        }

        @Override
        public void onSuccess() {
            ViComputer.this.setState(this.newState);
            this.set(Success.getInstance());
        }

        @Override
        public void onError(LocalizedMethodFault error) {
            RemoteException remoteException = new RemoteException(error.getLocalizedMessage());
            this.set(remoteException.getMessage(), remoteException);
        }
    }
}

