/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.impl.vmware.esx.vim25;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimService;
import java.net.MalformedURLException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.Executor;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import net.java.dev.vcc.api.Log;
import net.java.dev.vcc.spi.LogFactoryManager;

public class ConnectionManager {
    public static VimPortType getConnection(String url, Executor executor) throws MalformedURLException {
        final Log LOGGER = LogFactoryManager.getLogFactory().getLog(ConnectionManager.class);
        VimService vimService = new VimService(VimService.class.getResource("vimService.wsdl"), new QName("urn:vim25Service", "VimService"));
        vimService.setExecutor(executor);
        VimPortType proxy = vimService.getVimPort();
        BindingProvider bindingProvider = (BindingProvider)proxy;
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
        bindingProvider.getRequestContext().put("javax.xml.ws.session.maintain", true);
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }}, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sc.getSocketFactory();
            bindingProvider.getRequestContext().put("com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory", sslSocketFactory);
            bindingProvider.getRequestContext().put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", sslSocketFactory);
        }
        catch (Exception e) {
            LOGGER.info((Throwable)e, "Could not install the all-trusting socket factory");
        }
        HostnameVerifier verifier = new HostnameVerifier(){

            public boolean verify(String s, SSLSession sslSession) {
                LOGGER.debug("Verifying hostname: {0}", new Object[]{s});
                return true;
            }
        };
        bindingProvider.getRequestContext().put("com.sun.xml.internal.ws.transport.https.client.hostname.verifier", verifier);
        bindingProvider.getRequestContext().put("com.sun.xml.ws.transport.https.client.hostname.verifier", verifier);
        return proxy;
    }

    public static final ManagedObjectReference getServiceInstance() {
        ManagedObjectReference serviceInstance = new ManagedObjectReference();
        serviceInstance.setType("ServiceInstance");
        serviceInstance.setValue("ServiceInstance");
        return serviceInstance;
    }
}

