/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.impl.vmware.esx;

import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskFilterSpec;
import com.vmware.vim25.TaskInfo;
import com.vmware.vim25.TaskInfoState;
import java.util.Arrays;
import java.util.List;
import net.java.dev.vcc.api.Log;
import net.java.dev.vcc.api.LogFactory;
import net.java.dev.vcc.impl.vmware.esx.ViDatacenter;

final class ViTaskCollector
implements Runnable {
    private final ManagedObjectReference taskCollector;
    private ViDatacenter viDatacenter;
    private final Log log;

    public ViTaskCollector(ViDatacenter viDatacenter, LogFactory logFactory) throws RuntimeFaultFaultMsg, InvalidStateFaultMsg {
        this.viDatacenter = viDatacenter;
        this.log = logFactory.getLog(this.getClass());
        TaskFilterSpec spec = new TaskFilterSpec();
        spec.setState(Arrays.asList(TaskInfoState.SUCCESS, TaskInfoState.ERROR));
        this.taskCollector = viDatacenter.getConnection().getProxy().createCollectorForTasks(viDatacenter.getConnection().getServiceContent().getTaskManager(), spec);
        viDatacenter.getConnection().getProxy().resetCollector(this.taskCollector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.log.debug("Starting collecting tasks");
        try {
            boolean finished = false;
            while (!this.viDatacenter.isClosing() && !finished) {
                List tasks;
                try {
                    tasks = this.viDatacenter.getConnection().getProxy().readNextTasks(this.taskCollector, 100);
                }
                catch (RuntimeFaultFaultMsg e) {
                    this.log.error((Throwable)e, e.getMessage());
                    this.log.debug("Finished collecting tasks.");
                    return;
                }
                for (TaskInfo task : tasks) {
                    this.viDatacenter.processTask(task);
                }
            }
        }
        finally {
            this.log.debug("Finished collecting tasks.");
        }
    }
}

