/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.impl.vmware.esx;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import net.java.dev.vcc.api.Command;
import net.java.dev.vcc.api.Computer;
import net.java.dev.vcc.api.HostResourceGroup;
import net.java.dev.vcc.api.ManagedObjectId;
import net.java.dev.vcc.impl.vmware.esx.ViComputer;
import net.java.dev.vcc.impl.vmware.esx.ViComputerId;
import net.java.dev.vcc.impl.vmware.esx.ViDatacenter;
import net.java.dev.vcc.impl.vmware.esx.ViDatacenterResourceGroup;
import net.java.dev.vcc.impl.vmware.esx.ViHostId;
import net.java.dev.vcc.impl.vmware.esx.ViHostResourceGroup;
import net.java.dev.vcc.impl.vmware.esx.ViHostResourceGroupId;
import net.java.dev.vcc.spi.AbstractHost;
import net.java.dev.vcc.util.CompletedFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ViHost
extends AbstractHost {
    private final ViDatacenter datacenter;
    private String name;
    private ViDatacenterResourceGroup parent;
    private final Map<ViComputerId, ViComputer> computers = Collections.synchronizedMap(new HashMap());
    private final Map<ViHostResourceGroupId, ViHostResourceGroup> resourceGroups = Collections.synchronizedMap(new HashMap());

    ViHost(ViDatacenter datacenter, ViHostId id, ViDatacenterResourceGroup parent, String name) {
        super((ManagedObjectId)id);
        this.datacenter = datacenter;
        this.parent = parent;
        this.name = name;
    }

    public Set<Class<? extends Command>> getCommands() {
        return Collections.emptySet();
    }

    public <T extends Command> T execute(T command) {
        command.setSubmitted((Future)new CompletedFuture("Unsupported command", (Throwable)new UnsupportedOperationException()));
        return command;
    }

    public Set<HostResourceGroup> getHostResourceGroups() {
        return Collections.unmodifiableSet(new HashSet<ViHostResourceGroup>(this.resourceGroups.values()));
    }

    public Set<Computer> getComputers() {
        return Collections.unmodifiableSet(new HashSet<ViComputer>(this.computers.values()));
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    void setParent(ViDatacenterResourceGroup parent) {
        this.parent = parent;
    }

    void addComputer(ViComputer viComputer) {
        this.computers.put(viComputer.getId(), viComputer);
    }

    public void addHostResourceGroup(ViHostResourceGroup viResourceGroup) {
        this.resourceGroups.put(viResourceGroup.getId(), viResourceGroup);
    }

    void removeComputer(ViComputer viComputer) {
        this.computers.remove((Object)viComputer.getId());
    }

    public void removeResourceGroup(ViHostResourceGroup viResourceGroup) {
        this.resourceGroups.remove((Object)viResourceGroup.getId());
    }

    public ViHostId getId() {
        return (ViHostId)super.getId();
    }
}

