/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.util;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import net.java.dev.vcc.util.ServiceLoaderProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceLoaderCache<T> {
    private final Class<T> serviceClass;
    private final Map<ClassLoader, WeakReference<ServiceLoaderProxy<T>>> serviceLoaderCache = new WeakHashMap<ClassLoader, WeakReference<ServiceLoaderProxy<T>>>();

    public ServiceLoaderCache(Class<T> serviceClass) {
        this.serviceClass = serviceClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ServiceLoaderProxy<T> get(ClassLoader classloader) {
        Map<ClassLoader, WeakReference<ServiceLoaderProxy<T>>> map = this.serviceLoaderCache;
        synchronized (map) {
            ServiceLoaderProxy<T> result;
            WeakReference<ServiceLoaderProxy<T>> ref = this.serviceLoaderCache.get(classloader);
            if (ref != null && (result = (ServiceLoaderProxy<T>)ref.get()) != null) {
                return result;
            }
            result = ServiceLoaderProxy.load(this.serviceClass, classloader);
            this.serviceLoaderCache.put(classloader, new WeakReference<ServiceLoaderProxy<T>>(result));
            return result;
        }
    }
}

