/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompletedFuture<T>
implements Future<T> {
    private final T value;
    private final String message;
    private final Throwable cause;

    public CompletedFuture(T value) {
        this.value = value;
        this.message = null;
        this.cause = null;
    }

    public CompletedFuture(String message, Throwable cause) {
        this.message = message;
        this.cause = cause;
        this.value = null;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public T get() throws ExecutionException {
        if (this.cause == null) {
            return this.value;
        }
        throw new ExecutionException(this.message, this.cause);
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException {
        return this.get();
    }
}

