/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.api.profiles;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.java.dev.vcc.api.CapabilityProfile;
import net.java.dev.vcc.api.Command;
import net.java.dev.vcc.api.ManagedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AbstractProfile
implements CapabilityProfile {
    private final Map<Class<? extends ManagedObject>, Set<Class<? extends Command>>> capabilities;

    public AbstractProfile(Map.Entry<Class<? extends ManagedObject>, Set<Class<? extends Command>>> ... capabilities) {
        HashMap<Class<? extends ManagedObject>, Set<Class<? extends Command>>> tmp = new HashMap<Class<? extends ManagedObject>, Set<Class<? extends Command>>>(capabilities.length);
        for (Map.Entry<Class<? extends ManagedObject>, Set<Class<? extends Command>>> capability : capabilities) {
            tmp.put(capability.getKey(), capability.getValue());
        }
        this.capabilities = Collections.unmodifiableMap(tmp);
    }

    public AbstractProfile(CapabilityProfile base, Map.Entry<Class<? extends ManagedObject>, Set<Class<? extends Command>>> ... capabilities) {
        HashMap<Class<? extends ManagedObject>, Set<Class<? extends Command>>> tmp = new HashMap<Class<? extends ManagedObject>, Set<Class<? extends Command>>>(capabilities.length);
        for (Map.Entry<Class<? extends ManagedObject>, Set<Class<? extends Command>>> capability : capabilities) {
            tmp.put(capability.getKey(), capability.getValue());
        }
        for (Class<? extends ManagedObject> moc : base.getObjectClasses()) {
            HashSet<Class<? extends Command>> foo = new HashSet<Class<? extends Command>>(base.getCommands(moc));
            if (tmp.containsKey(moc)) {
                foo.addAll((Collection)tmp.get(moc));
            }
            tmp.put(moc, Collections.unmodifiableSet(foo));
        }
        this.capabilities = Collections.unmodifiableMap(tmp);
    }

    public AbstractProfile(CapabilityProfile ... bases) {
        HashMap<Class<? extends ManagedObject>, Set<Class<? extends Command>>> tmp = new HashMap<Class<? extends ManagedObject>, Set<Class<? extends Command>>>();
        for (CapabilityProfile base : bases) {
            for (Class<? extends ManagedObject> moc : base.getObjectClasses()) {
                HashSet<Class<? extends Command>> foo = new HashSet<Class<? extends Command>>(base.getCommands(moc));
                if (tmp.containsKey(moc)) {
                    foo.addAll((Collection)tmp.get(moc));
                }
                tmp.put(moc, Collections.unmodifiableSet(foo));
            }
        }
        this.capabilities = Collections.unmodifiableMap(tmp);
    }

    protected static Map.Entry<Class<? extends ManagedObject>, Set<Class<? extends Command>>> with(Class<? extends ManagedObject> object, Class<? extends Command> ... commands) {
        return new AbstractMap.SimpleImmutableEntry<Class<? extends ManagedObject>, Set<Class<? extends Command>>>(object, Collections.unmodifiableSet(new HashSet<Class<? extends Command>>(Arrays.asList(commands))));
    }

    @Override
    public final Set<Class<? extends Command>> getCommands(Class<? extends ManagedObject> managedObjectClass) {
        Set<Class<? extends Command>> result = this.capabilities.get(managedObjectClass);
        return result == null ? Collections.emptySet() : result;
    }

    @Override
    public final Set<Class<? extends ManagedObject>> getObjectClasses() {
        return this.capabilities.keySet();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CapabilityProfile)) {
            return false;
        }
        CapabilityProfile that = (CapabilityProfile)o;
        if (!((Object)this.capabilities.keySet()).equals(that.getObjectClasses())) {
            return false;
        }
        for (Class<? extends ManagedObject> b : this.capabilities.keySet()) {
            if (((Object)this.capabilities.get(b)).equals(that.getCommands(b))) continue;
            return false;
        }
        return true;
    }

    public final boolean supportedBy(CapabilityProfile that) {
        if (this == that) {
            return true;
        }
        if (!this.capabilities.keySet().containsAll(that.getObjectClasses())) {
            return false;
        }
        for (Class<? extends ManagedObject> b : this.capabilities.keySet()) {
            if (this.capabilities.get(b).containsAll(that.getCommands(b))) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean supports(CapabilityProfile that) {
        if (this == that) {
            return true;
        }
        if (!that.getObjectClasses().containsAll(this.capabilities.keySet())) {
            return false;
        }
        for (Class<? extends ManagedObject> b : that.getObjectClasses()) {
            if (that.getCommands(b).containsAll((Collection)this.capabilities.get(b))) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        return ((Object)this.capabilities.keySet()).hashCode();
    }

    public final String toString() {
        StringBuilder buf = new StringBuilder(512);
        buf.append("Profile[");
        boolean first = true;
        for (Map.Entry<Class<? extends ManagedObject>, Set<Class<? extends Command>>> b : this.capabilities.entrySet()) {
            if (!first) {
                buf.append(", ");
            } else {
                first = false;
            }
            buf.append(b.getKey().getSimpleName());
            buf.append('{');
            boolean innerFirst = true;
            for (Class<? extends Command> c : b.getValue()) {
                if (!innerFirst) {
                    buf.append(", ");
                } else {
                    innerFirst = false;
                }
                buf.append(c.getSimpleName());
            }
            buf.append('}');
        }
        buf.append(']');
        return buf.toString();
    }
}

