/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.ant;

import java.util.Comparator;
import java.util.TreeSet;
import net.java.dev.vcc.ant.AbstractDatacenterTask;
import net.java.dev.vcc.api.Computer;
import net.java.dev.vcc.api.Datacenter;
import net.java.dev.vcc.api.PowerState;
import org.apache.tools.ant.BuildException;

public class ListComputersTask
extends AbstractDatacenterTask {
    protected void execute(Datacenter datacenter) throws BuildException {
        TreeSet<Computer> computers = new TreeSet<Computer>(new Comparator<Computer>(){

            @Override
            public int compare(Computer o1, Computer o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        computers.addAll(datacenter.getAllComputers());
        for (Computer computer : computers) {
            PowerState state = computer.getState();
            this.log(this.rightPad("\"" + computer.getName() + "\" ", 70 - state.toString().length(), ".") + " " + state.toString(), 2);
        }
    }

    private String rightPad(String s, int i, String s1) {
        StringBuffer buf = new StringBuffer(i);
        buf.append(s);
        while (buf.length() < i) {
            buf.append(s1.substring(0, Math.min(s1.length(), i - buf.length())));
        }
        return buf.toString();
    }
}

