/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.vcc.ant;

import java.io.IOException;
import net.java.dev.vcc.ant.AntLogFactory;
import net.java.dev.vcc.api.Datacenter;
import net.java.dev.vcc.api.DatacenterManager;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class AbstractDatacenterTask
extends Task {
    private String datacenterUri;
    private String username;
    private String password;

    public final void execute() throws BuildException {
        AntLogFactory.setTask(this);
        if (this.datacenterUri == null) {
            throw new BuildException("The datacenter URI must be specified the datacenteruri attribute");
        }
        if (this.username == null) {
            throw new BuildException("The username must be specified the username attribute");
        }
        if (this.password == null) {
            throw new BuildException("The password must be specified the password attribute");
        }
        Datacenter datacenter = null;
        try {
            datacenter = DatacenterManager.getConnection((String)this.datacenterUri, (String)this.username, (char[])this.password.toCharArray());
            if (datacenter == null) {
                throw new BuildException("Unknown datacenter URI");
            }
            this.execute(datacenter);
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (datacenter != null) {
                datacenter.close();
            }
            AntLogFactory.setTask(null);
        }
    }

    protected abstract void execute(Datacenter var1) throws BuildException;

    public final String getDatacenteruri() {
        return this.datacenterUri;
    }

    public final void setDatacenteruri(String datacenterUri) {
        this.datacenterUri = datacenterUri;
    }

    public final String getUsername() {
        return this.username;
    }

    public final void setUsername(String username) {
        this.username = username;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String password) {
        this.password = password;
    }
}

