/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.springannotation.web;

import java.lang.reflect.Field;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import net.java.dev.springannotation.annotation.Value;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

public class JSFBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    private int order = Integer.MAX_VALUE;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        BeanWrapperImpl bw = new BeanWrapperImpl(bean);
        try {
            FacesContext fc = FacesContext.getCurrentInstance();
            if (fc != null) {
                Field[] fields;
                for (Field f : fields = bean.getClass().getDeclaredFields()) {
                    Value a = f.getAnnotation(Value.class);
                    if (a == null || !a.value().startsWith("#{")) continue;
                    ValueBinding vb = fc.getApplication().createValueBinding(a.value());
                    Object val = vb.getValue(fc);
                    try {
                        if (val == null) continue;
                        bw.setPropertyValue(f.getName(), val);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return bean;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

