/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.springannotation.scopes;

import java.util.HashMap;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.web.context.request.RequestContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationScope
implements Scope {
    private final String SCOPE_KEY = ConversationScope.class.getName() + ".SCOPEDMAP";

    private HashMap<String, Object> getScopedValues() {
        HashMap scopedObj = (HashMap)RequestContextHolder.currentRequestAttributes().getAttribute(this.SCOPE_KEY, 1);
        if (scopedObj == null) {
            scopedObj = new HashMap();
            RequestContextHolder.currentRequestAttributes().setAttribute(this.SCOPE_KEY, scopedObj, 1);
        }
        return scopedObj;
    }

    public Object get(String name, ObjectFactory objectFactory) {
        Object scopedObject = this.getScopedValues().get(name);
        if (scopedObject == null && objectFactory != null) {
            scopedObject = objectFactory.getObject();
            this.getScopedValues().put(name, scopedObject);
        }
        return scopedObject;
    }

    public Object remove(String name) {
        Object scopedObject = this.getScopedValues().get(name);
        if (scopedObject != null) {
            this.getScopedValues().remove(name);
            return scopedObject;
        }
        return null;
    }

    public void clearScope() {
        this.getScopedValues().clear();
    }

    public void set(String name, Object value) {
        this.getScopedValues().put(name, value);
    }

    public String getConversationId() {
        return "conversation";
    }

    public void registerDestructionCallback(String arg0, Runnable arg1) {
    }
}

