/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.springannotation.jsf.utils;

import java.util.EnumSet;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

public class EnumConverter
implements Converter {
    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        EnumSet<Enum> es;
        if (value == null || value.length() < 1) {
            return null;
        }
        int pos = value.indexOf(64);
        if (pos < 0) {
            throw new IllegalArgumentException(value + " do not point to an enum");
        }
        String clazz = value.substring(0, pos);
        int ordinal = Integer.parseInt(value.substring(pos + 1), 10);
        try {
            es = EnumSet.allOf(Class.forName(clazz));
        }
        catch (ClassNotFoundException e1) {
            throw new RuntimeException(e1);
        }
        for (Enum e : es) {
            if (e.ordinal() != ordinal) continue;
            return e;
        }
        throw new IllegalArgumentException("ordinal " + ordinal + " not found in enum " + clazz);
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        if (value == null) {
            return "";
        }
        Enum e = (Enum)value;
        if (component instanceof UIInput) {
            return e.getClass().getName() + "@" + Integer.toString(e.ordinal(), 10);
        }
        return e.name();
    }
}

