/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.springannotation.jsf.utils;

import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.VariableResolver;
import net.java.dev.springannotation.jsf.utils.DataModelFactoryRegistry;
import net.java.dev.springannotation.scopes.ConversationScope;
import net.java.dev.springannotation.scopes.FlashScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.jsf.FacesContextUtils;

public class DelegatingVariableResolver
extends VariableResolver {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected final VariableResolver originalVariableResolver;
    private DataModelFactoryRegistry dataModelfactoryRegistry;

    public DelegatingVariableResolver(VariableResolver originalVariableResolver) {
        Assert.notNull((Object)originalVariableResolver, (String)"Original JSF VariableResolver must not be null");
        this.originalVariableResolver = originalVariableResolver;
    }

    protected final VariableResolver getOriginalVariableResolver() {
        return this.originalVariableResolver;
    }

    public Object resolveVariable(FacesContext facesContext, String name) throws EvaluationException {
        Object result = null;
        BeanFactory bf = this.getBeanFactory(facesContext);
        result = this.resolve(facesContext, name, bf);
        if (result == null) {
            if (this.dataModelfactoryRegistry == null) {
                this.dataModelfactoryRegistry = (DataModelFactoryRegistry)bf.getBean("dataModelfactoryRegistry");
            }
            if (this.dataModelfactoryRegistry.hasFactory(name)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Attempting to call factory method for '" + name + "'"));
                }
                String fstring = this.dataModelfactoryRegistry.getFactory(name);
                MethodBinding factory = facesContext.getApplication().createMethodBinding(fstring, null);
                factory.invoke(facesContext, null);
                result = this.resolve(facesContext, name, bf);
            }
        }
        return result;
    }

    private Object resolve(FacesContext facesContext, String name, BeanFactory bf) {
        Object originalResult;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempting to resolve variable '" + name + "' in root WebApplicationContext"));
        }
        if (bf.containsBean(name)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Successfully resolved variable '" + name + "' in root WebApplicationContext"));
            }
            return bf.getBean(name);
        }
        ConversationScope conversationScope = (ConversationScope)bf.getBean("conversationScopeBean");
        Object object = conversationScope.get(name, null);
        if (object != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Successfully resolved variable '" + name + "' in root Conversation Scope"));
            }
            return object;
        }
        FlashScope flashScope = (FlashScope)bf.getBean("flashScopeBean");
        object = flashScope.get(name, null);
        if (object != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Successfully resolved variable '" + name + "' in root Flash Scope"));
            }
            return object;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempting to resolve variable '" + name + "' in via original VariableResolver"));
        }
        if ((originalResult = this.getOriginalVariableResolver().resolveVariable(facesContext, name)) != null) {
            return originalResult;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Could not resolve variable '" + name + "'"));
        }
        return null;
    }

    protected BeanFactory getBeanFactory(FacesContext facesContext) {
        return this.getWebApplicationContext(facesContext);
    }

    protected WebApplicationContext getWebApplicationContext(FacesContext facesContext) {
        return FacesContextUtils.getRequiredWebApplicationContext((FacesContext)facesContext);
    }
}

