/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.springannotation.aop;

import java.lang.reflect.Method;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import net.java.dev.springannotation.annotation.Bean;
import net.java.dev.springannotation.annotation.IfInvalid;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidValue;

@Aspect
public class ValidationInterceptor {
    @Pointcut(value="@within(net.java.dev.springannotation.annotation.ManagedBean)")
    public void inAManagedBean() {
    }

    @Pointcut(value="execution(@net.java.dev.springannotation.annotation.IfInvalid public String *.*())")
    public void needValidation() {
    }

    @Around(value="inAManagedBean() && needValidation()")
    public Object actionNeedingValidation(ProceedingJoinPoint thisJoinPoint) throws Throwable {
        ClassValidator cv = new ClassValidator(thisJoinPoint.getTarget().getClass());
        InvalidValue[] invalidmessages = cv.getInvalidValues(thisJoinPoint.getTarget());
        int unresolvedCount = 0;
        if (invalidmessages != null && invalidmessages.length > 0) {
            Signature sig = thisJoinPoint.getSignature();
            IfInvalid ann = null;
            String beanName = this.findName(thisJoinPoint.getTarget());
            FacesContext fc = FacesContext.getCurrentInstance();
            if (sig instanceof MethodSignature) {
                Method method = ((MethodSignature)sig).getMethod();
                ann = method.getAnnotation(IfInvalid.class);
            }
            for (InvalidValue iv : invalidmessages) {
                String message = iv.getMessage();
                String clientId = this.findClientId(fc, (UIComponent)fc.getViewRoot(), beanName, iv.getPropertyName());
                if (clientId != null) {
                    fc.addMessage(clientId, new FacesMessage(message));
                    continue;
                }
                ++unresolvedCount;
            }
            if (unresolvedCount == 0 || unresolvedCount < invalidmessages.length) {
                return ann == null || "".equals(ann.outcome()) ? null : ann.outcome();
            }
            return thisJoinPoint.proceed();
        }
        return thisJoinPoint.proceed();
    }

    private String findClientId(FacesContext ctx, UIComponent viewRoot, String beanName, String propertyPath) {
        Iterator i = viewRoot.getFacetsAndChildren();
        while (i.hasNext()) {
            UIComponent c = (UIComponent)i.next();
            if (c instanceof UIInput) {
                UIInput inp = (UIInput)c;
                ValueBinding vb = inp.getValueBinding("value");
                if (vb == null || !("#{" + beanName + "." + propertyPath + "}").equals(vb.getExpressionString())) continue;
                return inp.getClientId(ctx);
            }
            String val = this.findClientId(ctx, c, beanName, propertyPath);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    private String findName(Object target) {
        Bean b = target.getClass().getAnnotation(Bean.class);
        if (b != null) {
            return b.name();
        }
        return null;
    }
}

