/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.springannotation.aop;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.java.dev.springannotation.annotation.Out;
import net.java.dev.springannotation.annotation.Scope;
import net.java.dev.springannotation.scopes.ConversationScope;
import net.java.dev.springannotation.scopes.FlashScope;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.web.context.request.RequestContextHolder;

@Aspect
public class InOutInterceptor {
    private final HashMap<Class, Boolean> classCache = new HashMap();
    private final HashMap<Class, Set<String>> fieldsCache = new HashMap();
    private FlashScope flashScopeBean;
    private ConversationScope conversationScopeBean;

    public void setConversationScopeBean(ConversationScope conversationScopeBean) {
        this.conversationScopeBean = conversationScopeBean;
    }

    public void setFlashScopeBean(FlashScope flashScopeBean) {
        this.flashScopeBean = flashScopeBean;
    }

    @Pointcut(value="@within(net.java.dev.springannotation.annotation.ManagedBean)")
    public void inAManagedBean() {
    }

    @Pointcut(value="execution(public String *.*()) || execution(public void *(javax.faces.event.ActionEvent))")
    public void inActionOrEventMethod() {
    }

    @After(value="inAManagedBean() && inActionOrEventMethod()")
    public void actionWithOutValues(JoinPoint jp) throws Throwable {
        Class<?> c = jp.getTarget().getClass();
        Boolean hasOutFields = this.classCache.get(c);
        if (hasOutFields == null) {
            hasOutFields = false;
            for (Field f : c.getDeclaredFields()) {
                if (f.getAnnotation(Out.class) == null) continue;
                hasOutFields = true;
                break;
            }
            this.classCache.put(c, hasOutFields);
        }
        if (hasOutFields.booleanValue()) {
            Set<String> fc = this.fieldsCache.get(c);
            if (fc == null) {
                fc = new HashSet<String>();
                for (Field f : c.getDeclaredFields()) {
                    if (f.getAnnotation(Out.class) == null) continue;
                    fc.add(f.getName());
                }
                this.fieldsCache.put(c, fc);
            }
            for (String fname : fc) {
                Object value;
                Field f;
                f = c.getDeclaredField(fname);
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                if ((value = f.get(jp.getTarget())) == null) {
                    return;
                }
                Out out = f.getAnnotation(Out.class);
                if (Scope.DEFAULT.equals((Object)out.scope())) {
                    if ("flash".equals(out.scopeName())) {
                        this.flashScopeBean.set(fname, value);
                        continue;
                    }
                    if (!"conversation".equals(out.scopeName())) continue;
                    this.conversationScopeBean.set(fname, value);
                    continue;
                }
                RequestContextHolder.currentRequestAttributes().setAttribute(fname, value, out.scope().getValue());
            }
        }
    }
}

