/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.springannotation.jsf.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;

    public void afterPhase(PhaseEvent event) {
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext ctx = event.getFacesContext();
        UIViewRoot vr = ctx.getViewRoot();
        this.traverse(ctx, (UIComponent)vr, null, null);
    }

    private void traverse(FacesContext ctx, UIComponent comp, Map<String, ClassValidator> validators, Map<String, Object> values) {
        if (validators == null) {
            validators = new HashMap<String, ClassValidator>();
        }
        if (values == null) {
            values = new HashMap<String, Object>();
        }
        if (comp instanceof UIInput) {
            Object o;
            InvalidValue[] ivs;
            ClassValidator cv1;
            Object value;
            ValueBinding vb = ((UIInput)comp).getValueBinding("value");
            String exp = vb.getExpressionString();
            String name = exp.replaceAll("#{(.*?)\\..*}", "$1");
            String path = exp.replaceAll("#{.*?\\.(.*)}", "$1");
            ClassValidator cv = validators.get("name");
            if (cv == null && (value = (vb = ctx.getApplication().createValueBinding(String.format("#{%s}", name))).getValue(ctx)) != null && (cv1 = new ClassValidator(value.getClass())).hasValidationRules()) {
                cv = cv1;
                validators.put(name, cv);
                values.put(name, value);
            }
            if (cv != null && (ivs = cv.getInvalidValues(o = values.get(name), path)) != null && ivs.length >= 0) {
                InvalidValue[] invalidValueArray = ivs;
                int n = 0;
                int n2 = invalidValueArray.length;
                while (n < n2) {
                    InvalidValue iv = invalidValueArray[n];
                    ctx.addMessage(comp.getClientId(ctx), new FacesMessage(iv.getMessage()));
                    ++n;
                }
            }
        }
        Iterator it = comp.getFacetsAndChildren();
        while (it != null && it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            this.traverse(ctx, child, validators, values);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.PROCESS_VALIDATIONS;
    }
}

