/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.springannotation.jsf.utils;

import java.lang.reflect.Field;
import java.util.HashMap;
import net.java.dev.springannotation.annotation.DataModel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class DataModelFactoryRegistry
implements BeanFactoryPostProcessor {
    private HashMap<String, String> registry = new HashMap();

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] stringArray = beanFactory.getBeanDefinitionNames();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String bdn = stringArray[n];
            BeanDefinition bd = beanFactory.getBeanDefinition(bdn);
            Class c = this.getDefinitionClass(bd);
            if (c != null) {
                Field[] fieldArray = c.getDeclaredFields();
                int n3 = 0;
                int n4 = fieldArray.length;
                while (n3 < n4) {
                    Field f = fieldArray[n3];
                    DataModel dm = f.getAnnotation(DataModel.class);
                    if (dm != null && !"".equals(dm.factory())) {
                        this.registry.put("".equals(dm.name()) ? f.getName() : dm.name(), dm.factory());
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    public boolean hasFactory(String name) {
        return this.registry.containsKey(name);
    }

    public String getFactory(String name) {
        return this.registry.get(name);
    }

    private Class getDefinitionClass(BeanDefinition bd) {
        try {
            return Class.forName(bd.getBeanClassName());
        }
        catch (Throwable e) {
            return null;
        }
    }
}

