/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.springannotation.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.model.DataModelListener;
import javax.faces.model.ListDataModel;
import net.java.dev.springannotation.annotation.Bean;
import net.java.dev.springannotation.annotation.DataModel;
import net.java.dev.springannotation.annotation.DataModelIndex;
import net.java.dev.springannotation.annotation.DataModelSelection;
import net.java.dev.springannotation.annotation.Scope;
import net.java.dev.springannotation.aop.ListDataModelListener;
import net.java.dev.springannotation.scopes.ConversationScope;
import net.java.dev.springannotation.scopes.FlashScope;
import net.java.dev.springannotation.scopes.internal.FakeObjectFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.web.context.request.RequestContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Aspect
public class DataModelInterceptor {
    private final HashMap<Class, Boolean> classCache = new HashMap();
    private final HashMap<Class, String> dataModelCache = new HashMap();
    private final HashMap<Class, String> dataModelSelectionCache = new HashMap();
    private final HashMap<Class, String> dataModelIndexCache = new HashMap();
    private final HashMap<Class, String> beanNameCache = new HashMap();
    private FlashScope flashScopeBean;
    private ConversationScope conversationScopeBean;

    public void setConversationScopeBean(ConversationScope conversationScopeBean) {
        this.conversationScopeBean = conversationScopeBean;
    }

    public void setFlashScopeBean(FlashScope flashScopeBean) {
        this.flashScopeBean = flashScopeBean;
    }

    @Pointcut(value="@within(net.java.dev.springannotation.annotation.ManagedBean)")
    public void inAManagedBean() {
    }

    @Pointcut(value="execution(public String *()) || execution(public void *(javax.faces.event.ActionEvent))")
    public void inActionOrEventMethod() {
    }

    @After(value="inAManagedBean() && inActionOrEventMethod()")
    public void actionWithOutValues(JoinPoint jp) throws Throwable {
        Class<?> c = jp.getTarget().getClass();
        Boolean hasOutFields = this.classCache.get(c);
        if (hasOutFields == null) {
            hasOutFields = false;
            Field[] fieldArray = c.getDeclaredFields();
            int n = 0;
            int n2 = fieldArray.length;
            while (n < n2) {
                Field f = fieldArray[n];
                if (f.getAnnotation(DataModel.class) != null) {
                    hasOutFields = true;
                    break;
                }
                ++n;
            }
            this.classCache.put(c, hasOutFields);
        }
        if (hasOutFields.booleanValue()) {
            ValueBinding vb;
            List value;
            String bn;
            String dmif;
            String dmsf;
            String dmf = this.dataModelCache.get(c);
            if (dmf == null) {
                dmf = this.findAnnotationInFields(c, DataModel.class, this.dataModelCache);
            }
            if ((dmsf = this.dataModelSelectionCache.get(c)) == null) {
                dmsf = this.findAnnotationInFields(c, DataModelSelection.class, this.dataModelSelectionCache);
            }
            if ((dmif = this.dataModelIndexCache.get(c)) == null) {
                dmif = this.findAnnotationInFields(c, DataModelIndex.class, this.dataModelIndexCache);
            }
            if ((bn = this.beanNameCache.get(c)) == null) {
                bn = this.findBeanName(c, this.beanNameCache);
            }
            String listValueExpression = String.format("#{%s.%s}", bn, dmf);
            String indexValueExpression = null;
            String selectionValueExpression = null;
            if (dmif != null) {
                indexValueExpression = String.format("#{%s.%s}", bn, dmif);
            }
            if (dmsf != null) {
                selectionValueExpression = String.format("#{%s.%s}", bn, dmsf);
            }
            if ((value = (List)(vb = FacesContext.getCurrentInstance().getApplication().createValueBinding(listValueExpression)).getValue(FacesContext.getCurrentInstance())) == null) {
                return;
            }
            ListDataModel ldm = new ListDataModel(value);
            ListDataModelListener dml = new ListDataModelListener(indexValueExpression, selectionValueExpression);
            ldm.addDataModelListener((DataModelListener)dml);
            Field f = c.getDeclaredField(dmf);
            DataModel dm = f.getAnnotation(DataModel.class);
            String dmname = dmf;
            if (!"".equals(dm.name())) {
                dmname = dm.name();
            }
            if (!dm.scope().equals((Object)Scope.DEFAULT)) {
                RequestContextHolder.currentRequestAttributes().setAttribute(dmname, (Object)ldm, dm.scope().getValue());
            } else if ("flash".equals(dm.scopeName())) {
                this.flashScopeBean.get(dmname, (ObjectFactory)new FakeObjectFactory((Object)ldm));
            } else if ("conversation".equals(dm.scopeName())) {
                this.conversationScopeBean.get(dmname, (ObjectFactory)new FakeObjectFactory((Object)ldm));
            }
        }
    }

    private String findBeanName(Class<?> c, HashMap<Class, String> cache) {
        Bean b = c.getAnnotation(Bean.class);
        if (b != null && !"".equals(b.name())) {
            cache.put(c, b.name());
            return b.name();
        }
        return null;
    }

    private String findAnnotationInFields(Class<?> c, Class<? extends Annotation> ann, HashMap<Class, String> cache) {
        String name = null;
        Field[] fieldArray = c.getDeclaredFields();
        int n = 0;
        int n2 = fieldArray.length;
        while (n < n2) {
            Field f = fieldArray[n];
            if (f.getAnnotation(ann) != null) {
                name = f.getName();
                cache.put(c, name);
                break;
            }
            ++n;
        }
        return name;
    }
}

