/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import net.java.ao.EntityManager;
import net.java.ao.RawEntity;

public final class EntityUtils {
    public static String getTableName(EntityManager em, Class<? extends RawEntity<?>> entityType) {
        return EntityUtils.getTableName(em, entityType, true);
    }

    public static String getTableName(EntityManager em, Class<? extends RawEntity<?>> entityType, boolean escape) {
        String tableName = em.getProvider().shorten(em.getTableNameConverter().getName(entityType));
        return escape ? em.getProvider().withSchema(tableName) : tableName;
    }

    public static String getFieldName(EntityManager em, Class<? extends RawEntity<?>> entityType, String methodName) {
        return em.getProvider().shorten(em.getFieldNameConverter().getName(EntityUtils.findMethod(entityType, methodName)));
    }

    public static String getPolyFieldName(EntityManager em, Class<? extends RawEntity<?>> entityType, String methodName) {
        return em.getProvider().shorten(em.getFieldNameConverter().getPolyTypeName(EntityUtils.findMethod(entityType, methodName)));
    }

    public static String escapeFieldName(EntityManager em, Class<? extends RawEntity<?>> entityType, String methodName) {
        return EntityUtils.escapeKeyword(em, EntityUtils.getFieldName(em, entityType, methodName));
    }

    public static String escapePolyFieldName(EntityManager em, Class<? extends RawEntity<?>> entityType, String methodName) {
        return EntityUtils.escapeKeyword(em, EntityUtils.getPolyFieldName(em, entityType, methodName));
    }

    public static String escapeKeyword(EntityManager em, String keyword) {
        return em.getProvider().processID(keyword);
    }

    private static Method findMethod(Class<? extends RawEntity<?>> entityType, final String methodName) {
        return (Method)Iterables.find((Iterable)Lists.newArrayList((Object[])entityType.getMethods()), (Predicate)new Predicate<Method>(){

            public boolean apply(Method m) {
                return m.getName().equals(methodName);
            }
        });
    }
}

