/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.jdbc;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import net.java.ao.test.ConfigurationProperties;
import net.java.ao.test.jdbc.AbstractJdbcConfiguration;
import net.java.ao.test.jdbc.DerbyEmbedded;
import net.java.ao.test.jdbc.H2File;
import net.java.ao.test.jdbc.H2Memory;
import net.java.ao.test.jdbc.H2Server;
import net.java.ao.test.jdbc.Hsql;
import net.java.ao.test.jdbc.HsqlFileStorage;
import net.java.ao.test.jdbc.JdbcConfiguration;
import net.java.ao.test.jdbc.MySql;
import net.java.ao.test.jdbc.NuoDB;
import net.java.ao.test.jdbc.Oracle;
import net.java.ao.test.jdbc.Postgres;
import net.java.ao.test.jdbc.SqlServer;
import net.java.ao.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicJdbcConfiguration
extends AbstractJdbcConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DynamicJdbcConfiguration.class);
    private static final ImmutableMap<String, JdbcConfiguration> CONFIGS = ImmutableMap.builder().put((Object)"hsql", (Object)new Hsql()).put((Object)"h2-memory", (Object)new H2Memory()).put((Object)"h2-file", (Object)new H2File()).put((Object)"h2-server", (Object)new H2Server()).put((Object)"hsql-file", (Object)new HsqlFileStorage()).put((Object)"mysql", (Object)new MySql()).put((Object)"postgres", (Object)new Postgres()).put((Object)"oracle", (Object)new Oracle()).put((Object)"sqlserver", (Object)new SqlServer()).put((Object)"derby-embedded", (Object)new DerbyEmbedded()).put((Object)"nuodb", (Object)new NuoDB()).build();
    private static final String DEFAULT = "hsql";
    private static final Supplier<JdbcConfiguration> jdbcSupplier = Suppliers.memoize((Supplier)new SystemPropertyJdbcConfigurationSupplier());

    public DynamicJdbcConfiguration() {
        super(((JdbcConfiguration)jdbcSupplier.get()).getUrl(), ((JdbcConfiguration)jdbcSupplier.get()).getUsername(), ((JdbcConfiguration)jdbcSupplier.get()).getPassword(), ((JdbcConfiguration)jdbcSupplier.get()).getSchema());
    }

    protected DynamicJdbcConfiguration(String url, String username, String password, String schema) {
        super(url, username, password, schema);
    }

    @Override
    public String getUrl() {
        return ((JdbcConfiguration)jdbcSupplier.get()).getUrl();
    }

    @Override
    protected String getDefaultSchema() {
        return ((JdbcConfiguration)jdbcSupplier.get()).getSchema();
    }

    @Override
    protected String getDefaultUrl() {
        return ((JdbcConfiguration)jdbcSupplier.get()).getUrl();
    }

    @Override
    public String getUsername() {
        return ((JdbcConfiguration)jdbcSupplier.get()).getUsername();
    }

    @Override
    public String getPassword() {
        return ((JdbcConfiguration)jdbcSupplier.get()).getPassword();
    }

    @Override
    public String getSchema() {
        return ((JdbcConfiguration)jdbcSupplier.get()).getSchema();
    }

    private static final class SystemPropertyJdbcConfigurationSupplier
    implements Supplier<JdbcConfiguration> {
        private SystemPropertyJdbcConfigurationSupplier() {
        }

        public JdbcConfiguration get() {
            String db = ConfigurationProperties.get("ao.test.database", DynamicJdbcConfiguration.DEFAULT);
            JdbcConfiguration jdbcConfiguration = this.buildJdbcConfiguration(db);
            logger.debug("JDBC configuration key is {} and resolved to {}", (Object)db, (Object)jdbcConfiguration);
            jdbcConfiguration.init();
            return jdbcConfiguration;
        }

        private JdbcConfiguration buildJdbcConfiguration(String db) {
            JdbcConfiguration jdbcConfiguration = null;
            String username = ConfigurationProperties.get("db.username", null);
            String password = ConfigurationProperties.get("db.password", null);
            String dbUrl = ConfigurationProperties.get("db.url", null);
            String dbSchema = ConfigurationProperties.get("db.schema", null);
            if (!(StringUtils.isBlank((String)username) && StringUtils.isBlank((String)password) && StringUtils.isBlank((String)dbUrl) && StringUtils.isBlank((String)dbSchema))) {
                if ("postgres".equals(db)) {
                    jdbcConfiguration = new Postgres(dbUrl, username, password, dbSchema);
                } else if (DynamicJdbcConfiguration.DEFAULT.equals(db)) {
                    jdbcConfiguration = new Hsql(dbUrl, username, password, dbSchema);
                } else if ("h2-memory".equals(db)) {
                    jdbcConfiguration = new H2Memory(dbUrl, username, password, dbSchema);
                } else if ("h2-file".equals(db)) {
                    jdbcConfiguration = new H2File(dbUrl, username, password, dbSchema);
                } else if ("h2-server".equals(db)) {
                    jdbcConfiguration = new H2Server(dbUrl, username, password, dbSchema);
                } else if ("hsql-file".equals(db)) {
                    jdbcConfiguration = new HsqlFileStorage(dbUrl, username, password, dbSchema);
                } else if ("mysql".equals(db)) {
                    jdbcConfiguration = new MySql(dbUrl, username, password, dbSchema);
                } else if ("nuodb".equals(db)) {
                    jdbcConfiguration = new NuoDB(dbUrl, username, password, dbSchema);
                } else if ("oracle".equals(db)) {
                    jdbcConfiguration = new Oracle(dbUrl, username, password, dbSchema);
                } else if ("sqlserver".equals(db)) {
                    jdbcConfiguration = new SqlServer(dbUrl, username, password, dbSchema);
                } else if ("derby-embedded".equals(db)) {
                    jdbcConfiguration = new DerbyEmbedded(dbUrl, username, password, dbSchema);
                }
            } else {
                jdbcConfiguration = (JdbcConfiguration)CONFIGS.get((Object)db);
            }
            return jdbcConfiguration;
        }
    }
}

