/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.test.jdbc;

import net.java.ao.test.ConfigurationProperties;
import net.java.ao.test.jdbc.Hsql;

public class HsqlFileStorage
extends Hsql {
    private static final String TEST_HOME_CONSTANT = "${testHome}";
    private static final String FILE_URL = "jdbc:hsqldb:${testHome}/database/ao_test";
    private static final String DEFAULT_TEST_HOME = "target/testHome";

    public HsqlFileStorage() {
        super(HsqlFileStorage.getFileUrl());
    }

    public HsqlFileStorage(String url, String username, String password, String schema) {
        super(url, username, password, schema);
    }

    @Override
    protected String getDefaultUrl() {
        return HsqlFileStorage.getFileUrl();
    }

    private static String getFileUrl() {
        return HsqlFileStorage.replaceTestHomeConstant(FILE_URL, HsqlFileStorage.getTestHome());
    }

    private static String replaceTestHomeConstant(String in, String testHome) {
        if (in == null) {
            return null;
        }
        StringBuilder prop = new StringBuilder(in);
        int length = TEST_HOME_CONSTANT.length();
        int index = prop.indexOf(TEST_HOME_CONSTANT);
        while (index != -1) {
            prop.replace(index, index + length, testHome);
            index = prop.indexOf(TEST_HOME_CONSTANT);
        }
        return prop.toString();
    }

    private static String getTestHome() {
        return ConfigurationProperties.get("test.home", DEFAULT_TEST_HOME);
    }
}

