package net.java.ao.schema.info;

import net.java.ao.RawEntity;

import java.lang.reflect.Method;
import java.util.Set;

/**
 * A description of the table generated by the {@link RawEntity}
 * <p/>
 * Note this is different to {@link net.java.ao.types.TypeInfo} which describes what type a column is in the database.
 * {@code EntityInfo} describes the table.
 *
 * @param <T> the {@link RawEntity entity} interface
 * @param <K> the primary key for the entity
 * @since 0.21
 */
public interface EntityInfo<T extends RawEntity<K>, K> {

    /**
     * @return the inteface for the entity {@code <T>}
     */
    Class<T> getEntityType();

    /**
     * @return the name of the table
     */
    String getName();

    /**
     * @return the primary key for the table
     */
    FieldInfo<K> getPrimaryKey();

    /**
     * @return all the fields for the table
     */
    Set<FieldInfo> getFields();

    /**
     * @return all the field names for the table
     * @see FieldInfo#getName()
     */
    Set<String> getFieldNames();

    /**
     * @param method an accessor or mutator from the {@link #getEntityType() entity}
     * @return the {@link FieldInfo} associated with the method.
     */
    FieldInfo getField(Method method);

    /**
     * @param fieldName the name of the database column
     * @return the {@link FieldInfo} associated with the fieldName
     */
    FieldInfo getField(String fieldName);

    /**
     * @param method the method to test whether it is an accessor
     * @return {@code true} if the method is an accessor for the {@link #getEntityType() entity}, {@code false} otherwise
     */
    boolean hasAccessor(Method method);

    /**
     * @param method the method to test whether it is an mutator
     * @return {@code true} if the method is an mutator for the {@link #getEntityType() entity}, {@code false} otherwise
     */
    boolean hasMutator(Method method);

    /**
     * @param fieldName the name of the database column
     * @return {@code true} if the fieldName is associated with the {@link #getEntityType() entity}, {@code false} otherwise
     */
    boolean hasField(String fieldName);

}
