/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.schema;

import com.google.common.base.Preconditions;
import net.java.ao.RawEntity;
import net.java.ao.schema.CanonicalClassNameTableNameConverter;
import net.java.ao.schema.Table;
import net.java.ao.schema.TableNameConverter;

public final class TableAnnotationTableNameConverter
implements TableNameConverter {
    public static final Class<Table> TABLE_ANNOTATION = Table.class;
    private final TableNameConverter delegateTableNameConverter;
    private final CanonicalClassNameTableNameConverter postProcessingTableNameConverter;

    public TableAnnotationTableNameConverter(TableNameConverter delegateTableNameConverter) {
        this(delegateTableNameConverter, new IdentityTableNameConverter());
    }

    public TableAnnotationTableNameConverter(TableNameConverter delegateTableNameConverter, CanonicalClassNameTableNameConverter postProcessingTableNameConverter) {
        this.delegateTableNameConverter = (TableNameConverter)Preconditions.checkNotNull((Object)delegateTableNameConverter);
        this.postProcessingTableNameConverter = (CanonicalClassNameTableNameConverter)Preconditions.checkNotNull((Object)postProcessingTableNameConverter);
    }

    @Override
    public String getName(Class<? extends RawEntity<?>> entityClass) {
        if (entityClass.isAnnotationPresent(TABLE_ANNOTATION)) {
            return this.postProcessingTableNameConverter.getName(this.validate(entityClass.getAnnotation(TABLE_ANNOTATION).value()));
        }
        return this.delegateTableNameConverter.getName(entityClass);
    }

    private String validate(String value) {
        Preconditions.checkState((value != null && !value.equals("") ? 1 : 0) != 0, (String)"Value %s for table annotation is not valid.", (Object[])new Object[]{value});
        return value;
    }

    private static class IdentityTableNameConverter
    extends CanonicalClassNameTableNameConverter {
        private IdentityTableNameConverter() {
        }

        @Override
        protected String getName(String entityClassCanonicalName) {
            return entityClassCanonicalName;
        }
    }
}

