/*
 * Decompiled with CFR 0.152.
 */
package net.java.ao.cache;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.java.ao.RawEntity;
import net.java.ao.cache.CacheLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RAMCacheLayer
implements CacheLayer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Object> values;
    private final ReadWriteLock valueLock = new ReentrantReadWriteLock();
    private Set<String> dirty;
    private final ReadWriteLock dirtyLock = new ReentrantReadWriteLock();
    private Set<Class<? extends RawEntity<?>>> flush;
    private final ReadWriteLock flushLock = new ReentrantReadWriteLock();

    RAMCacheLayer() {
        this.values = new HashMap<String, Object>();
        this.dirty = new HashSet<String>();
        this.flush = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.dirtyLock.readLock().lock();
        this.valueLock.writeLock().lock();
        try {
            HashSet<String> toRemove = new HashSet<String>();
            for (String field : this.values.keySet()) {
                if (this.dirty.contains(field)) continue;
                toRemove.add(field);
            }
            for (String field : toRemove) {
                this.values.remove(field);
            }
            this.logger.debug("clear");
        }
        finally {
            this.valueLock.writeLock().unlock();
            this.dirtyLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDirty() {
        this.dirtyLock.writeLock().lock();
        try {
            this.dirty.clear();
            this.logger.debug("clearDirty");
        }
        finally {
            this.dirtyLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFlush() {
        this.flushLock.writeLock().lock();
        try {
            this.flush.clear();
            this.logger.debug("clearFlush");
        }
        finally {
            this.flushLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String field) {
        this.valueLock.readLock().lock();
        try {
            boolean contains = this.values.containsKey(field);
            this.logger.debug("contains ( {} ) : {}", (Object)field, (Object)contains);
            boolean bl = contains;
            return bl;
        }
        finally {
            this.valueLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dirtyContains(String field) {
        this.dirtyLock.readLock().lock();
        try {
            boolean contains = this.dirty.contains(field);
            this.logger.debug("dirtyContains ( {} ) : {}", (Object)field, (Object)contains);
            boolean bl = contains;
            return bl;
        }
        finally {
            this.dirtyLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String field) {
        this.valueLock.readLock().lock();
        try {
            Object o = this.values.get(field);
            this.logger.debug("get ( {} ) : {}", (Object)field, o);
            Object object = o;
            return object;
        }
        finally {
            this.valueLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getDirtyFields() {
        this.dirtyLock.readLock().lock();
        try {
            Object[] strings = this.dirty.toArray(new String[this.dirty.size()]);
            this.logger.debug("getDirtyFields : {}", (Object)Arrays.toString(strings));
            Object[] objectArray = strings;
            return objectArray;
        }
        finally {
            this.dirtyLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<? extends RawEntity<?>>[] getToFlush() {
        this.flushLock.readLock().lock();
        try {
            Object[] classes = this.flush.toArray(new Class[this.flush.size()]);
            this.logger.debug("getToFlush : {}", classes);
            Object[] objectArray = classes;
            return objectArray;
        }
        finally {
            this.flushLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markDirty(String field) {
        this.dirtyLock.writeLock().lock();
        try {
            this.dirty.add(field);
            this.logger.debug("markDirty( {} )", (Object)field);
        }
        finally {
            this.dirtyLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markToFlush(Class<? extends RawEntity<?>> type) {
        this.flushLock.writeLock().lock();
        try {
            this.flush.add(type);
            this.logger.debug("markToFlush ( {} )", type);
        }
        finally {
            this.flushLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String field, Object value) {
        this.valueLock.writeLock().lock();
        try {
            this.values.put(field, value);
            this.logger.debug("put ( {}, {} )", (Object)field, value);
        }
        finally {
            this.valueLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String field) {
        this.valueLock.writeLock().lock();
        try {
            this.values.remove(field);
            this.logger.debug("remove ( {} )", (Object)field);
        }
        finally {
            this.valueLock.writeLock().unlock();
        }
    }
}

