/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.properties;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.jangaroo.properties.api.Propc;
import net.jangaroo.properties.api.PropcException;
import net.jangaroo.properties.api.PropcHelper;
import net.jangaroo.properties.model.PropertiesClass;
import net.jangaroo.properties.model.ResourceBundleClass;
import net.jangaroo.utils.FileLocations;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class PropertyClassGenerator
implements Propc {
    private static Configuration cfg = new Configuration();
    private static final String OUTPUT_CHARSET = "UTF-8";
    private FileLocations locations;

    public PropertyClassGenerator() {
    }

    public PropertyClassGenerator(FileLocations locations) {
        this.locations = locations;
    }

    public FileLocations getConfig() {
        return this.locations;
    }

    public void setConfig(FileLocations config) {
        this.locations = config;
    }

    public void generatePropertiesClass(PropertiesClass propertiesClass, Writer out) throws IOException, TemplateException {
        Template template = cfg.getTemplate("properties_class.ftl");
        Environment env = template.createProcessingEnvironment((Object)propertiesClass, out);
        env.setOutputEncoding(OUTPUT_CHARSET);
        env.process();
    }

    public File generateJangarooClass(PropertiesClass pl) {
        File outputFile = PropcHelper.computeGeneratedPropertiesClassFile((FileLocations)this.locations, (String)pl.getResourceBundle().getFullClassName(), (Locale)pl.getLocale());
        outputFile.getParentFile().mkdirs();
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), OUTPUT_CHARSET);
            this.generatePropertiesClass(pl, writer);
            File file = outputFile;
            return file;
        }
        catch (Exception e) {
            throw new PropcException((Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public Map<File, Set<File>> generate() {
        LinkedHashMap<File, Set<File>> outputFileMap = new LinkedHashMap<File, Set<File>>();
        for (File srcFile : this.locations.getSourceFiles()) {
            File outputFile = this.generate(srcFile);
            outputFileMap.put(srcFile, Collections.singleton(outputFile));
        }
        return outputFileMap;
    }

    public File generate(File propertiesFile) {
        PropertiesConfiguration p = new PropertiesConfiguration();
        p.setDelimiterParsingDisabled(true);
        Reader r = null;
        try {
            r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(propertiesFile), OUTPUT_CHARSET));
            p.load(r);
        }
        catch (IOException e) {
            throw new PropcException("Error while parsing properties file", propertiesFile, (Exception)e);
        }
        catch (ConfigurationException e) {
            throw new PropcException("Error while parsing properties file", propertiesFile, (Exception)((Object)e));
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
        ResourceBundleClass bundle = new ResourceBundleClass(PropcHelper.computeBaseClassName((FileLocations)this.locations, (File)propertiesFile));
        return this.generateJangarooClass(new PropertiesClass(bundle, PropcHelper.computeLocale((File)propertiesFile), p, propertiesFile));
    }

    static {
        cfg.setClassForTemplateLoading(PropertyClassGenerator.class, "/net/jangaroo/properties/templates");
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        cfg.setOutputEncoding(OUTPUT_CHARSET);
    }
}

