/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.properties.compiler;

import java.io.StringWriter;
import java.io.Writer;
import net.jangaroo.properties.PropertyClassGenerator;
import net.jangaroo.utils.FileLocations;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ExampleMode;

public final class PropertiesCompiler {
    private PropertiesCompiler() {
    }

    public static int run(String[] args) {
        FileLocations config = new FileLocations();
        CmdLineParser parser = new CmdLineParser((Object)config);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            StringBuilder msg = new StringBuilder();
            msg.append(e.getMessage());
            msg.append("\n");
            msg.append("java -jar properties-compiler.jar [options...] source files...\n");
            StringWriter writer = new StringWriter();
            parser.printUsage((Writer)writer, null);
            msg.append(writer.getBuffer());
            msg.append("\n");
            msg.append("  Example: java -jar properties-compiler.jar").append(parser.printExample(ExampleMode.REQUIRED));
            msg.append("\n");
            System.err.println(msg);
            return -1;
        }
        if (!config.getOutputDirectory().exists()) {
            throw new IllegalArgumentException("destination directory does not exist: " + config.getOutputDirectory().getAbsolutePath());
        }
        PropertyClassGenerator generator = new PropertyClassGenerator(config);
        generator.generate();
        return 0;
    }

    public static void main(String[] argv) {
        int result = PropertiesCompiler.run(argv);
        if (result != 0) {
            System.exit(result);
        }
    }
}

