/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.properties;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Locale;
import java.util.Properties;
import net.jangaroo.properties.model.LocalizationSuite;
import net.jangaroo.properties.model.PropertiesClass;
import net.jangaroo.properties.model.ResourceBundleClass;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.plexus.util.FileUtils;

public final class PropertiesFileScanner {
    private LocalizationSuite suite;

    public PropertiesFileScanner(LocalizationSuite suite) {
        this.suite = suite;
    }

    public LocalizationSuite getSuite() {
        return this.suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan() throws IOException {
        for (String srcFileRelativePath : new FileSetManager().getIncludedFiles(this.suite.getProperties())) {
            Locale locale;
            File srcFile = new File(this.suite.getRootDir(), srcFileRelativePath);
            String className = FileUtils.removeExtension((String)srcFile.getName());
            if (className.indexOf("_") != -1) {
                String localeString = className.substring(className.indexOf("_") + 1, className.length());
                if (localeString.indexOf("_") != -1) {
                    String lang = localeString.substring(0, localeString.indexOf("_"));
                    String countr = localeString.substring(lang.length() + 1, localeString.length());
                    if (countr.indexOf("_") != -1) {
                        String var = countr.substring(countr.indexOf("_") + 1, countr.length());
                        countr = countr.substring(0, countr.indexOf("_"));
                        locale = new Locale(lang, countr, var);
                    } else {
                        locale = new Locale(lang, countr);
                    }
                } else {
                    locale = new Locale(localeString);
                }
                className = className.substring(0, className.indexOf("_"));
            } else {
                locale = null;
            }
            String packageName = FileUtils.dirname((String)srcFileRelativePath).replaceAll("[\\\\/]", ".");
            String fullName = packageName != null && !"".equals(packageName) ? packageName + "." + className : className;
            ResourceBundleClass bundle = this.suite.getClassByFullName(fullName);
            if (bundle == null) {
                bundle = new ResourceBundleClass(fullName);
                this.suite.addResourceBundleClass(bundle);
            }
            Properties p = new Properties();
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(srcFile), "UTF-8"));
            try {
                p.load(r);
            }
            finally {
                ((Reader)r).close();
            }
            new PropertiesClass(bundle, locale, p, srcFile);
        }
    }
}

