/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.utils;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.jangaroo.utils.AS3Type;

public final class CompilerUtils {
    public static final String PROPERTIES_CLASS_SUFFIX = "_properties";
    public static final String PROPERTIES_SUFFIX = ".properties";
    private static final Pattern ATTRIBUTE_NORMALIZED_WHITESPACE = Pattern.compile("  +");

    private CompilerUtils() {
    }

    public static String qName(String packageName, String className) {
        return packageName == null || packageName.length() == 0 ? className : packageName + "." + className;
    }

    public static String packageName(String qName) {
        int lastDotPos = qName.lastIndexOf(46);
        return lastDotPos == -1 ? "" : qName.substring(0, lastDotPos);
    }

    public static String uncapitalize(String name) {
        int capitalCount;
        if (name == null) {
            return name;
        }
        for (capitalCount = 0; capitalCount < name.length() && Character.isUpperCase(name.charAt(capitalCount)); ++capitalCount) {
        }
        int toLowerCount = capitalCount <= 1 || capitalCount == name.length() ? capitalCount : capitalCount - 1;
        return new StringBuilder(name.length()).append(name.substring(0, toLowerCount).toLowerCase(Locale.ROOT)).append(name.substring(toLowerCount)).toString();
    }

    public static String className(String qName) {
        int lastDotPos = qName.lastIndexOf(46);
        return lastDotPos == -1 ? qName : qName.substring(lastDotPos + 1);
    }

    public static File fileFromQName(String packageName, String className, File baseDirectory, String extension) {
        return CompilerUtils.fileFromQName(CompilerUtils.qName(packageName, className), baseDirectory, extension);
    }

    public static File fileFromQName(String qName, File baseDirectory, String extension) {
        return new File(baseDirectory, CompilerUtils.fileNameFromQName(qName, File.separatorChar, extension));
    }

    public static String fileNameFromQName(String qName, char separatorChar, String extension) {
        String correctedQName = qName;
        if (PROPERTIES_SUFFIX.equals(extension)) {
            if (qName.endsWith(PROPERTIES_CLASS_SUFFIX)) {
                correctedQName = qName.substring(0, qName.length() - PROPERTIES_CLASS_SUFFIX.length());
            } else {
                return null;
            }
        }
        return correctedQName.replace('.', separatorChar) + extension;
    }

    public static File findSourceDir(List<File> sourcePath, File file) throws IOException {
        File canonicalFile = file.getCanonicalFile();
        for (File sourceDir : sourcePath) {
            if (CompilerUtils.qNameFromFile(sourceDir, canonicalFile) == null) continue;
            return sourceDir;
        }
        return null;
    }

    public static String qNameFromFile(List<File> sourcePath, File file) throws IOException {
        return CompilerUtils.qNameFromFile(CompilerUtils.findSourceDir(sourcePath, file), file);
    }

    public static String qNameFromFile(File baseDirectory, File file) {
        String relativePath = CompilerUtils.getRelativePath(baseDirectory, file);
        return CompilerUtils.qNameFromRelativePath(relativePath);
    }

    public static String qNameFromRelativePath(String relativePath) {
        if (relativePath != null) {
            int lastDotPos = relativePath.lastIndexOf(46);
            relativePath = relativePath.replace(File.separatorChar, '/');
            if (lastDotPos != -1 && lastDotPos > relativePath.lastIndexOf(47)) {
                String qName = relativePath.substring(0, lastDotPos).replace('/', '.');
                String suffix = relativePath.substring(lastDotPos);
                if (PROPERTIES_SUFFIX.equals(suffix)) {
                    qName = qName + PROPERTIES_CLASS_SUFFIX;
                }
                return qName;
            }
        }
        return null;
    }

    public static String getRelativePath(File baseDirectory, File file) {
        return CompilerUtils.getRelativePath(baseDirectory, file, true);
    }

    public static String getRelativePath(File baseDirectory, File file, boolean onlyBelowBaseDirectory) {
        try {
            return CompilerUtils.getRelativePath(baseDirectory.getCanonicalPath() + File.separator, file.getCanonicalPath(), File.separator, onlyBelowBaseDirectory);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("could not determine qualified name from file; the strange file is called " + file + " in " + baseDirectory, e);
        }
    }

    static String getRelativePathBelow(String canonicalBasePath, String canonicalPath) {
        if (canonicalPath.length() > canonicalBasePath.length() && canonicalPath.startsWith(canonicalBasePath)) {
            return canonicalPath.substring(canonicalBasePath.length());
        }
        return null;
    }

    static String getRelativePath(String canonicalBasePath, String canonicalPath, String fileSeparator, boolean onlyBelowBaseDirectory) {
        String relativePath = CompilerUtils.getRelativePathBelow(canonicalBasePath, canonicalPath);
        if (relativePath == null && !onlyBelowBaseDirectory) {
            int i;
            String fileSeparatorAsRegExp = Pattern.quote(fileSeparator);
            String[] basePathParts = canonicalBasePath.split(fileSeparatorAsRegExp);
            String[] pathParts = canonicalPath.split(fileSeparatorAsRegExp, -1);
            int samePartCount = basePathParts.length;
            for (int i2 = 0; i2 < basePathParts.length; ++i2) {
                if (basePathParts[i2].equals(pathParts[i2])) continue;
                samePartCount = i2;
                break;
            }
            StringBuilder builder = new StringBuilder();
            for (i = samePartCount; i < basePathParts.length; ++i) {
                builder.append("..").append(fileSeparator);
            }
            for (i = samePartCount; i < pathParts.length; ++i) {
                builder.append(pathParts[i]);
                if (i >= pathParts.length - 1) continue;
                builder.append(fileSeparator);
            }
            relativePath = builder.toString();
        }
        return relativePath;
    }

    public static String dirname(String filename) {
        int i = filename.lastIndexOf(File.separator);
        return i >= 0 ? filename.substring(0, i) : "";
    }

    public static String removeExtension(String filename) {
        String ext = CompilerUtils.extension(filename);
        if ("".equals(ext)) {
            return filename;
        }
        int index = filename.lastIndexOf(ext) - 1;
        return filename.substring(0, index);
    }

    public static String extension(String filename) {
        int lastDot;
        int lastSep = filename.lastIndexOf(File.separatorChar);
        if (lastSep < 0) {
            lastDot = filename.lastIndexOf(46);
        } else {
            lastDot = filename.substring(lastSep + 1).lastIndexOf(46);
            if (lastDot >= 0) {
                lastDot += lastSep + 1;
            }
        }
        if (lastDot >= 0 && lastDot > lastSep) {
            return filename.substring(lastDot + 1);
        }
        return "";
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String unquote(String quotedString) {
        return quotedString != null && (quotedString.startsWith("'") && quotedString.endsWith("'") || quotedString.startsWith("\"") && quotedString.endsWith("\"")) ? quotedString.substring(1, quotedString.length() - 1) : null;
    }

    public static AS3Type guessType(String attributeValue) {
        attributeValue = attributeValue.trim();
        try {
            long l = Long.parseLong(attributeValue);
            return l >= 0L ? AS3Type.UINT : AS3Type.INT;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double.parseDouble(attributeValue);
                return AS3Type.NUMBER;
            }
            catch (NumberFormatException numberFormatException2) {
                if ("false".equalsIgnoreCase(attributeValue) || "true".equalsIgnoreCase(attributeValue)) {
                    return AS3Type.BOOLEAN;
                }
                return null;
            }
        }
    }

    public static String denormalizeAttributeValue(String value) {
        if (value.contains("\n")) {
            return value;
        }
        Matcher matcher = ATTRIBUTE_NORMALIZED_WHITESPACE.matcher(value);
        StringBuilder result = new StringBuilder();
        int pos = 0;
        while (matcher.find()) {
            result.append(value, pos, matcher.start());
            result.append("\n");
            result.append(value, matcher.start() + 1, matcher.end());
            pos = matcher.end();
        }
        result.append(value, pos, value.length());
        return result.toString();
    }
}

