/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.utils;

public enum AS3Type {
    BOOLEAN("Boolean", "false"),
    NUMBER("Number", "NaN"),
    INT("int", "0"),
    UINT("uint", "0"),
    STRING("String", "null"),
    ARRAY("Array", "null"),
    REG_EXP("RegExp", "null"),
    DATE("Date", "null"),
    ANY("*", "undefined"),
    VOID("void", "undefined");

    public final String name;
    public final String defaultValue;

    private AS3Type(String name, String defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public static AS3Type typeByName(String name) {
        if (name != null) {
            for (AS3Type value : AS3Type.values()) {
                if (!value.toString().equals(name)) continue;
                return value;
            }
        }
        return null;
    }

    public static String getDefaultValue(String typeName) {
        AS3Type type = typeName != null ? AS3Type.typeByName(typeName) : ANY;
        return type == null ? "null" : type.defaultValue;
    }

    public String toString() {
        return this.name;
    }
}

