/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.utils;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import net.jangaroo.utils.AS3Type;

public final class CompilerUtils {
    private CompilerUtils() {
    }

    public static String qName(String packageName, String className) {
        return packageName.length() == 0 ? className : packageName + "." + className;
    }

    public static String packageName(String qName) {
        int lastDotPos = qName.lastIndexOf(46);
        return lastDotPos == -1 ? "" : qName.substring(0, lastDotPos);
    }

    public static String uncapitalize(String name) {
        int capitalCount;
        if (name == null) {
            return name;
        }
        for (capitalCount = 0; capitalCount < name.length() && Character.isUpperCase(name.charAt(capitalCount)); ++capitalCount) {
        }
        int toLowerCount = capitalCount <= 1 || capitalCount == name.length() ? capitalCount : capitalCount - 1;
        return new StringBuilder(name.length()).append(name.substring(0, toLowerCount).toLowerCase(Locale.ROOT)).append(name.substring(toLowerCount)).toString();
    }

    public static String className(String qName) {
        int lastDotPos = qName.lastIndexOf(46);
        return lastDotPos == -1 ? qName : qName.substring(lastDotPos + 1);
    }

    public static File fileFromQName(String packageName, String className, File baseDirectory, String extension) {
        return CompilerUtils.fileFromQName(CompilerUtils.qName(packageName, className), baseDirectory, extension);
    }

    public static File fileFromQName(String qName, File baseDirectory, String extension) {
        char separatorChar = File.separatorChar;
        return new File(baseDirectory, CompilerUtils.fileNameFromQName(qName, separatorChar, extension));
    }

    public static String fileNameFromQName(String qName, char separatorChar, String extension) {
        return qName.replace('.', separatorChar) + extension;
    }

    public static String qNameFromFile(File baseDirectory, File file) {
        int lastDotPos;
        String relativePath = CompilerUtils.getRelativePath(baseDirectory, file);
        if (relativePath != null && (lastDotPos = relativePath.lastIndexOf(46)) != -1 && lastDotPos > relativePath.lastIndexOf(File.separatorChar)) {
            return relativePath.substring(0, lastDotPos).replace(File.separatorChar, '.');
        }
        return null;
    }

    public static String getRelativePath(File baseDirectory, File file) {
        String relativePath = null;
        try {
            String canonicalBasePath = baseDirectory.getCanonicalPath() + File.separator;
            String canonicalPath = file.getCanonicalPath();
            if (canonicalPath.length() > canonicalBasePath.length() && canonicalPath.startsWith(canonicalBasePath)) {
                relativePath = canonicalPath.substring(canonicalBasePath.length());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("could not determine qualified name from file; the strange file is called " + file + " in " + baseDirectory, e);
        }
        return relativePath;
    }

    public static String dirname(String filename) {
        int i = filename.lastIndexOf(File.separator);
        return i >= 0 ? filename.substring(0, i) : "";
    }

    public static String removeExtension(String filename) {
        String ext = CompilerUtils.extension(filename);
        if ("".equals(ext)) {
            return filename;
        }
        int index = filename.lastIndexOf(ext) - 1;
        return filename.substring(0, index);
    }

    public static String extension(String filename) {
        int lastDot;
        int lastSep = filename.lastIndexOf(File.separatorChar);
        if (lastSep < 0) {
            lastDot = filename.lastIndexOf(46);
        } else {
            lastDot = filename.substring(lastSep + 1).lastIndexOf(46);
            if (lastDot >= 0) {
                lastDot += lastSep + 1;
            }
        }
        if (lastDot >= 0 && lastDot > lastSep) {
            return filename.substring(lastDot + 1);
        }
        return "";
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static AS3Type guessType(String attributeValue) {
        try {
            long l = Long.parseLong(attributeValue);
            return l >= 0L ? AS3Type.UINT : AS3Type.INT;
        }
        catch (NumberFormatException e) {
            try {
                Double.parseDouble(attributeValue);
                return AS3Type.NUMBER;
            }
            catch (NumberFormatException numberFormatException) {
                if ("false".equalsIgnoreCase(attributeValue) || "true".equalsIgnoreCase(attributeValue)) {
                    return AS3Type.BOOLEAN;
                }
                return null;
            }
        }
    }
}

