/*
 * Copyright 2009 CoreMedia AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 
 *
 * Unless required by applicable law or agreed to in writing, 
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either 
 * express or implied. See the License for the specific language 
 * governing permissions and limitations under the License.
 */

// JangarooScript runtime support. Author: Frank Wienberg

package joo {
public class NativeClassDeclaration {

  internal static const RESOURCE_BUNDLE_PATTERN:RegExp = /_properties$/;

  internal static native function createEmptyConstructor(prototype_ : Object) : Function;

  internal static const STATE_LOADED : int = 0;
  internal static const STATE_COMPLETING : int = 1;
  internal static const STATE_COMPLETED : int = 2;
  internal static const STATE_INITIALIZING : int = 3;
  internal static const STATE_INITIALIZED : int = 4;

  public var
          fullClassName : String,
          constructor_ : Function,
          publicConstructor : Function,
          state  : int = STATE_LOADED,
          Public : Function,
          superClassDeclaration : NativeClassDeclaration,
          Types: Class,
          interfaces : Array;

  public function NativeClassDeclaration(){super();}

  public native function create(fullClassName : String, publicConstructor : Function) : NativeClassDeclaration;

  public native function complete() : NativeClassDeclaration;

  internal native function doComplete() : void;

  protected native function initTypes():void;

  public native function init() : NativeClassDeclaration;

  internal native function doInit() : void;

  public native function getQualifiedName() : String;

  public native function toString() : String;
}
}