/*
 * Copyright 2009 CoreMedia AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

// JangarooScript runtime support. Author: Frank Wienberg

package joo {
public class DynamicClassLoader extends joo.StandardClassLoader {

  public static var INSTANCE:DynamicClassLoader;

  public function DynamicClassLoader(){super();}

  override public native function prepare(...params):JooClassDeclaration;

  public native function addDependency(dependency:String):void;

  public native function fireDependency(dependency:String):void;

  override protected native function doCompleteCallbacks(onCompleteCallbacks : Array/*Function*/):void;

  public native function classLoadErrorHandler(fullClassName:String, url:String):void;

  /**
   * Import the class given by its fully qualified class name (package plus name).
   * All imports are collected in a hash and can be used in the #complete() callback function.
   * Additionally, the DynamicClassLoader tries to load the class from a URL if it is not present on #complete().
   * @param fullClassName : String the fully qualified class name (package plus name) of the class to load and import.
   */
  public override native function import_(fullClassName : String) : void;

  override public native function run(mainClassName : String, ...args):void;

  public native function getResource(path:String):Object;

  /**
   * Tell Jangaroo to load and initialize all required classes, then call the given function.
   * The function receives an import hash, which can be used in pure JavaScript in a 'with' statement
   * (Jangaroo does not support 'with', there, you would use import declarations!) like this:
   * <pre>
   * joo.classLoader.import_("com.custom.Foo");
   * joo.classLoader.complete(function(imports){with(imports){
   *   Foo.doSomething("bar");
   * }});
   * </pre>
   * @param onCompleteCallback : Function
   * @return void
   */
  public override native function complete(onCompleteCallback : Function = undefined) : void;
}
}