Ext.define("net.jangaroo.net.URIImpl",function(URIImpl){function URIImpl$(scheme,authority,path,query,fragment){AS3.assert(path!==null,"URIImpl.as",41,5);this.scheme=scheme;this.authority=authority;this.path=path;this.query=query;this.fragment=fragment;this.isRelative=scheme===null;this.isAbsolute=!this.isRelative}function toString(){var toAppendTo=[];appendIfBothNonNull$static(this.scheme,":",toAppendTo);appendIfBothNonNull$static("//",this.authority,toAppendTo);toAppendTo.push(this.path);appendIfBothNonNull$static("?",
this.query,toAppendTo);appendIfBothNonNull$static("#",this.fragment,toAppendTo);return toAppendTo.join("")}function appendIfBothNonNull$static(s1,s2,toAppendTo){if(s1!==null&&s2!==null){toAppendTo.push(s1);toAppendTo.push(s2)}}function relativize(reference){if(!this.isAbsolute)throw new URIError("base URI must be absolute: "+this);if(!reference.isAbsolute)throw new URIError("URI to be relativized must be absolute: "+reference);var targetScheme=reference.scheme;if(targetScheme===null||targetScheme!==
this.scheme)return reference;var targetAuthority=reference.authority;if(targetScheme&&this.authority!==null&&targetAuthority===null)return reference;targetScheme=null;var targetPath=reference.path;var targetQuery=reference.query;var targetFragment=reference.fragment;if(this.authority===targetAuthority){targetAuthority=null;if(!targetPath)targetPath="";if(this.path!==null){var lastSlash=this.path.lastIndexOf("/");if(lastSlash>=0){var baseSegments=normalizedPathSegments$static(this.path);var targetPathSegments=
normalizedPathSegments$static(targetPath);var equalPaths=arraysEquals$static(baseSegments,targetPathSegments);if(equalPaths&&targetQuery===this.query&&targetFragment!==null&&targetFragment.length>0){targetPath="";targetQuery=null}else if(equalPaths)if(targetQuery===null){targetPath=targetPathSegments[targetPathSegments.length-1];if(""===targetPath)targetPath="."}else targetPath="";else targetPath=relativizePath$static(baseSegments,targetPathSegments)}}}return new URIImpl(targetScheme,targetAuthority,
targetPath,targetQuery,targetFragment)}function arraysEquals$static(a1,a2){if(a1.length!==a2.length)return false;for(var i=0;i<a1.length;i++)if(a1[i]!==a2[i])return false;return true}function relativizePath$static(baseSegments,pathSegments){AS3.assert(pathSegments.length>0,"URIImpl.as",154,5);AS3.assert(baseSegments.length>0,"URIImpl.as",155,5);var i=0;for(var n=Math.min(pathSegments.length-1,baseSegments.length-1);baseSegments[i]===pathSegments[i]&&i<n;i++);var currentDir=baseSegments.length-1;if(i===
currentDir&&i===pathSegments.length-1&&pathSegments[i]==="")return".";var j=currentDir;var sb=[];while(j>i){sb.push("..");j--;if(j>i)sb.push("/")}var nonemptyArcAdded=false;while(i<pathSegments.length){var arc=pathSegments[i];nonemptyArcAdded=nonemptyArcAdded||arc!=="";if(sb.length>0&&nonemptyArcAdded)sb.push("/");sb.push(arc);i++}return sb.join("")}function normalizedPathSegments$static(path){return pathSegments$static(removeDotSegments$static(path))}function pathSegments$static(path){return path.split("/")}
function resolve(reference){if(!this.isAbsolute)throw new URIError("base URI must be absolute: "+this);var targetScheme=reference.scheme;var targetAuthority=reference.authority;var targetPath=reference.path;var targetQuery=reference.query;var targetFragment=reference.fragment;if(targetScheme!==null)targetPath=removeDotSegments$static(targetPath);else{if(targetAuthority!==null)targetPath=removeDotSegments$static(targetPath);else{if(targetPath===null||targetPath===""){targetPath=this.path;if(targetQuery===
null)targetQuery=this.query}else targetPath=mergeAndRemoveDotSegments$static(this.authority,this.path,targetPath);targetAuthority=this.authority}targetScheme=this.scheme}return new URIImpl(targetScheme,targetAuthority,targetPath,targetQuery,targetFragment)}function removeDotSegments$static(path){return path==null?null:mergeAndRemoveDotSegments$static(null,"",path)}function mergeAndRemoveDotSegments$static(baseAuthority,basePath,relPath){var resultPath=[];var relSegments=pathSegments$static(relPath);
var ensureTrailingSlash=false;if(relPath.length==0||relPath.charAt(0)!=="/")if(basePath==null||basePath.length==0){if(baseAuthority!==null&&baseAuthority.length>0)resultPath.push("")}else{var baseSegments=pathSegments$static(basePath);baseSegments.forEach(function(segment){if(segment===".."){popSegment$static(resultPath);ensureTrailingSlash=true}else if(segment===".")ensureTrailingSlash=true;else{resultPath.push(segment);ensureTrailingSlash=false}});if(!ensureTrailingSlash&&resultPath.length>0)resultPath.pop()}relSegments.forEach(function(segment){if(segment===
".."){popSegment$static(resultPath);ensureTrailingSlash=true}else if(segment===".")ensureTrailingSlash=true;else{resultPath.push(segment);ensureTrailingSlash=false}});var result=resultPath.join("/");if(ensureTrailingSlash)if(result==="")result="/";else if(result.charAt(result.length-1)!=="/")result+="/";return result}function popSegment$static(segments){if(segments.length>1)segments.pop();else if(segments.length===1&&segments[0]!=="")segments[0]=""}return{mixins:["net.jangaroo.net.URI"],constructor:URIImpl$,
toString:toString,relativize:relativize,resolve:resolve,requires:["AS3.Error","net.jangaroo.net.URI"]}});Ext.define("net.jangaroo.net.URI",function(URI){return{}});Ext.define("net.jangaroo.net.URIUtils",function(URIUtils){var URI_PATTERN$static=/^(([^:/?#]+):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;var URI_PATTERN_GROUP_SCHEME_PRESENT$static=1;var URI_PATTERN_GROUP_SCHEME$static=2;var URI_PATTERN_GROUP_AUTHORITY_PRESENT$static=4;var URI_PATTERN_GROUP_AUTHORITY$static=4;var URI_PATTERN_GROUP_PATH$static=5;var URI_PATTERN_GROUP_QUERY$static=7;var URI_PATTERN_GROUP_QUERY_PRESENT$static=6;var URI_PATTERN_GROUP_FRAGMENT$static=9;var URI_PATTERN_GROUP_FRAGMENT_PRESENT$static=
8;function URIUtils$(){}function create(scheme,authority,path,query,fragment){switch(arguments.length){case 0:scheme=null;case 1:authority=null;case 2:path="";case 3:query=null;case 4:fragment=null}return new net.jangaroo.net.URIImpl(scheme,authority,path,query,fragment)}function parse$static(source){if(!source.match(URI_PATTERN$static))throw new AS3.Error("invalid URI syntax: "+source);var match=URI_PATTERN$static.exec(source);return new net.jangaroo.net.URIImpl(ifPresentOrNull$static(match,URI_PATTERN_GROUP_SCHEME$static,
URI_PATTERN_GROUP_SCHEME_PRESENT$static),ifPresentOrNull$static(match,URI_PATTERN_GROUP_AUTHORITY$static,URI_PATTERN_GROUP_AUTHORITY_PRESENT$static),ifPresentOrNull$static(match,URI_PATTERN_GROUP_PATH$static,URI_PATTERN_GROUP_PATH$static,""),ifPresentOrNull$static(match,URI_PATTERN_GROUP_QUERY$static,URI_PATTERN_GROUP_QUERY_PRESENT$static),ifPresentOrNull$static(match,URI_PATTERN_GROUP_FRAGMENT$static,URI_PATTERN_GROUP_FRAGMENT_PRESENT$static))}function ifPresentOrNull$static(match,valueGroup,presentGroup,
defaultValue){if(arguments.length<=3)defaultValue=null;var present=match[presentGroup];return present?match[valueGroup]:defaultValue}function relativize$static(base,reference){return String(URIUtils.parse(base).relativize(URIUtils.parse(reference)))}function resolve$static(base,reference){return String(URIUtils.parse(base).resolve(URIUtils.parse(reference)))}return{constructor:URIUtils$,create:create,statics:{parse:parse$static,relativize:relativize$static,resolve:resolve$static},requires:["AS3.Error"],
uses:["net.jangaroo.net.URIImpl"]}});
//# sourceMappingURL=net.jangaroo__jangaroo-net.js.map
