package net.jangaroo.net {

[Uses("net.jangaroo.net.URI")]
/**
 * A class implementing parsing, formatting, resolving and relativizing URIs in
 * generic URI syntax as specified in <a href="http://www.rfc-editor.org/rfc/rfc3986.txt">RFC 3986</a>.
 */
public class URIImpl implements net.jangaroo.net.URI {
  public native function get scheme():String;

  public native function set scheme(value:String):void;

  public native function get authority():String;

  public native function set authority(value:String):void;

  public native function get path():String;

  public native function set path(value:String):void;

  public native function get query():String;

  public native function set query(value:String):void;

  public native function get fragment():String;

  public native function set fragment(value:String):void;

  public native function get isRelative():Boolean;

  public native function set isRelative(value:Boolean):void;

  public native function get isAbsolute():Boolean;

  public native function set isAbsolute(value:Boolean):void;

  /**
   * Construct a new URIImpl instance.
   * None of the parameters may be undefined.
   * Use null to mark 'not defined' in RFC sense.
   * @param path must neither be undefined nor null, but might be the empty string
   */
  public function URIImpl(scheme:String, authority:String, path:String, query:String, fragment:String) {
    super();
  }

  /**
   * Return the string representation of this URI
   */
  public native function toString():String;

  /**
   * Relativize a reference uri against this URI according to RFC 3986.
   * If both scheme and authority are equal, this method always returns a URI with a relative path,
   * even it an absolute path would be shorter.
   *
   * @param reference the URI to relativize. Must be an absolute URI.
   * @return an URI which yields the reference URI when resolved against the given base URI
   * @throws URIError (todo IllegalArgumentException) if base or reference are relative URIs
   */
  public native function relativize(reference:net.jangaroo.net.URI):net.jangaroo.net.URI;

  /**
   * Resolve a uri against this as a base URI according to RFC 3986.
   * @requires this.isAbsolute()
   * @param reference     the uri to resolve
   * @return an absolute URI
   */
  public native function resolve(reference:net.jangaroo.net.URI):net.jangaroo.net.URI;
}
}