// class net.jangaroo.net.URI
joo.classLoader.prepare("package net.jangaroo.net",
"public interface URI",1,function($$private){return[,,,,,,,,,
undefined];},[],[], "0.8.0", "1.0.1"
);
// class net.jangaroo.net.URIImpl
joo.classLoader.prepare("package net.jangaroo.net",
"internal class URIImpl implements net.jangaroo.net.URI",1,function($$private){var assert=joo.assert,$1=net.jangaroo.net;return[
"public native function get scheme",
"public native function set scheme",
"public native function get authority",
"public native function set authority",
"public native function get path",
"public native function set path",
"public native function get query",
"public native function set query",
"public native function get fragment",
"public native function set fragment",
"public native function get isRelative",
"public native function set isRelative",
"public native function get isAbsolute",
"public native function set isAbsolute",
"public function URIImpl",function(scheme,authority,path,query,fragment){
assert(scheme!==undefined, "URIImpl.as", 41, 5);
assert(authority!==undefined, "URIImpl.as", 42, 5);
assert(path!==undefined, "URIImpl.as", 43, 5);
assert(path!==null, "URIImpl.as", 44, 5);
assert(query!==undefined, "URIImpl.as", 45, 5);
assert(fragment!==undefined, "URIImpl.as", 46, 5);
this.scheme=scheme;
this.authority=authority;
this.path=path;
this.query=query;
this.fragment=fragment;
this.isRelative=scheme===null;
this.isAbsolute=!this.isRelative;
},
"public function toString",function(){
var toAppendTo=[];
$$private.appendIfBothNonNull(this.scheme,":",toAppendTo);
$$private.appendIfBothNonNull("//",this.authority,toAppendTo);
toAppendTo.push(this.path);
$$private.appendIfBothNonNull("?",this.query,toAppendTo);
$$private.appendIfBothNonNull("#",this.fragment,toAppendTo);
return toAppendTo.join("");
},
"private static function appendIfBothNonNull",function(s1,s2,toAppendTo){
if(s1!==null&&s2!==null){
toAppendTo.push(s1);
toAppendTo.push(s2);
}
},
"public function relativize",function(reference){
if(!this.isAbsolute){
throw new URIError("base URI must be absolute: "+this);
}
if(!reference.isAbsolute){
throw new URIError("URI to be relativized must be absolute: "+reference);
}
var targetScheme=reference.scheme;
if(targetScheme===null||targetScheme!==this.scheme){
return reference;
}
var targetAuthority=reference.authority;
if(targetScheme&&this.authority!==null&&targetAuthority===null){
return reference;
}
targetScheme=null;
var targetPath=reference.path;
var targetQuery=reference.query;
var targetFragment=reference.fragment;
if(this.authority===targetAuthority){
targetAuthority=null;
if(!targetPath)
targetPath="";
if(this.path!==null){
var lastSlash=this.path.lastIndexOf('/');
if(lastSlash>=0){
var baseSegments=$$private.normalizedPathSegments(this.path);
var targetPathSegments=$$private.normalizedPathSegments(targetPath);var equalPaths=$$private.arraysEquals(baseSegments,targetPathSegments);
if(equalPaths&&
targetQuery===this.query&&
targetFragment!==null&&
targetFragment.length>0){
targetPath="";
targetQuery=null;
}else{
if(equalPaths){
if(targetQuery===null){
targetPath=targetPathSegments[targetPathSegments.length-1];
if(""===targetPath){
targetPath=".";
}
}else{
targetPath="";
}
}else{
targetPath=$$private.relativizePath(baseSegments,targetPathSegments);
}
}
}
}
}
return new $1.URIImpl(targetScheme,targetAuthority,targetPath,targetQuery,targetFragment);
},
"private static function arraysEquals",function(a1,a2){
if(a1.length!==a2.length){
return false;
}
for(var i=0;i<a1.length;i++){
if(a1[i]!==a2[i]){
return false;
}
}
return true;
},
"private static function relativizePath",function(baseSegments,pathSegments){
assert(pathSegments.length>0, "URIImpl.as", 159, 5);
assert(baseSegments.length>0, "URIImpl.as", 160, 5);
var i=0;
for(var n=Math.min(pathSegments.length-1,baseSegments.length-1);
baseSegments[i]===pathSegments[i]&&i<n;
i++){
}
var currentDir=baseSegments.length-1;
if(i===currentDir&&i===pathSegments.length-1&&pathSegments[i]===""){
return".";
}
var j=currentDir;
var sb=[];
while(j>i){
sb.push("..");
j--;
if(j>i){
sb.push("/");
}
}
var nonemptyArcAdded=false;
while(i<pathSegments.length){var arc=pathSegments[i];
nonemptyArcAdded=nonemptyArcAdded||arc!=="";
if(sb.length>0&&nonemptyArcAdded){
sb.push("/");
}
sb.push(arc);
i++;
}
return sb.join("");
},
"private static function normalizedPathSegments",function(path){
return $$private.pathSegments($$private.removeDotSegments(path));
},
"private static function pathSegments",function(path){
return path.split("/");
},
"public function resolve",function(reference){
if(!this.isAbsolute){
throw new URIError("base URI must be absolute: "+this);
}
var targetScheme=reference.scheme;
var targetAuthority=reference.authority;
var targetPath=reference.path;
var targetQuery=reference.query;
var targetFragment=reference.fragment;
if(targetScheme!==null){
targetPath=$$private.removeDotSegments(targetPath);
}else{
if(targetAuthority!==null){
targetPath=$$private.removeDotSegments(targetPath);
}else{
if(targetPath===null||targetPath===""){
targetPath=this.path;
if(targetQuery===null){
targetQuery=this.query;
}
}else{
targetPath=$$private.mergeAndRemoveDotSegments(this.authority,this.path,targetPath);
}
targetAuthority=this.authority;
}
targetScheme=this.scheme;
}
return new $1.URIImpl(targetScheme,targetAuthority,targetPath,targetQuery,targetFragment);
},
"private static function removeDotSegments",function(path){
return path==null?null:$$private.mergeAndRemoveDotSegments(null,"",path);
},
"private static function mergeAndRemoveDotSegments",function(baseAuthority,basePath,relPath){
var resultPath=[];
var relSegments=$$private.pathSegments(relPath);
var ensureTrailingSlash=false;
if(relPath.length==0||relPath.charAt(0)!=='/'){
if(basePath==null||basePath.length==0){
if(baseAuthority!==null&&baseAuthority.length>0){
resultPath.push("");
}
}else{
var baseSegments=$$private.pathSegments(basePath);
baseSegments.forEach(function(segment){
if(segment===".."){
$$private.popSegment(resultPath);
ensureTrailingSlash=true;
}else if(segment==="."){
ensureTrailingSlash=true;
}else{
resultPath.push(segment);
ensureTrailingSlash=false;
}
});
if(!ensureTrailingSlash&&resultPath.length>0){
resultPath.pop();
}
}
}
relSegments.forEach(function(segment){
if(segment===".."){
$$private.popSegment(resultPath);
ensureTrailingSlash=true;
}else if(segment==="."){
ensureTrailingSlash=true;
}else{
resultPath.push(segment);
ensureTrailingSlash=false;
}
});
var result=resultPath.join("/");
if(ensureTrailingSlash){
if(result===''){
result='/';
}else if(result.charAt(result.length-1)!=='/'){
result+='/';
}
}
return result;
},
"private static function popSegment",function(segments){
if(segments.length>1){
segments.pop();
}else if(segments.length===1&&segments[0]!==""){
segments[0]="";
}
},
undefined];},[],["net.jangaroo.net.URI"], "0.8.0", "1.0.1"
);
// class net.jangaroo.net.URIUtils
joo.classLoader.prepare("package net.jangaroo.net",
"public class URIUtils",1,function($$private){var $1=net.jangaroo.net;return[
"private static const",{URI_PATTERN:/^(([^:/?#]+):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/},
"private static const",{URI_PATTERN_GROUP_SCHEME_PRESENT:1},
"private static const",{URI_PATTERN_GROUP_SCHEME:2},
"private static const",{URI_PATTERN_GROUP_AUTHORITY_PRESENT:4},
"private static const",{URI_PATTERN_GROUP_AUTHORITY:4},
"private static const",{URI_PATTERN_GROUP_PATH:5},
"private static const",{URI_PATTERN_GROUP_QUERY:7},
"private static const",{URI_PATTERN_GROUP_QUERY_PRESENT:6},
"private static const",{URI_PATTERN_GROUP_FRAGMENT:9},
"private static const",{URI_PATTERN_GROUP_FRAGMENT_PRESENT:8},
"function URIUtils",function(){
},
"public function create",function(scheme,authority,path,query,fragment){switch(arguments.length){case 0:scheme=null;case 1:authority=null;case 2:path="";case 3:query=null;case 4:fragment=null;}
return new $1.URIImpl(scheme,authority,path,query,fragment);
},
"public static function parse",function(source){
if(!source.match($$private.URI_PATTERN)){
throw new Error("invalid URI syntax: "+source);
}
var match=$$private.URI_PATTERN.exec(source);
return new $1.URIImpl(
$$private.ifPresentOrNull(match,$$private.URI_PATTERN_GROUP_SCHEME,$$private.URI_PATTERN_GROUP_SCHEME_PRESENT),
$$private.ifPresentOrNull(match,$$private.URI_PATTERN_GROUP_AUTHORITY,$$private.URI_PATTERN_GROUP_AUTHORITY_PRESENT),
$$private.ifPresentOrNull(match,$$private.URI_PATTERN_GROUP_PATH,$$private.URI_PATTERN_GROUP_PATH,""),
$$private.ifPresentOrNull(match,$$private.URI_PATTERN_GROUP_QUERY,$$private.URI_PATTERN_GROUP_QUERY_PRESENT),
$$private.ifPresentOrNull(match,$$private.URI_PATTERN_GROUP_FRAGMENT,$$private.URI_PATTERN_GROUP_FRAGMENT_PRESENT));
},
"private static function ifPresentOrNull",function(match,valueGroup,presentGroup,defaultValue){if(arguments.length<=3)defaultValue=null;var present=match[presentGroup];
return present?match[valueGroup]:defaultValue;
},
"public static function relativize",function(base,reference){
return net.jangaroo.net.URIUtils.parse(base).relativize(net.jangaroo.net.URIUtils.parse(reference)).toString();
},
"public static function resolve",function(base,reference){
return net.jangaroo.net.URIUtils.parse(base).resolve(net.jangaroo.net.URIUtils.parse(reference)).toString();
},
undefined];},["parse","relativize","resolve"],["net.jangaroo.net.URIImpl"], "0.8.0", "1.0.1"
);
